/*
By Zhe Chen
This is the class that is used to invoke drawing functions to draw basic items and also to create a png file of the picture.  This was not wired up to the language because of time restrictions and also because
we found an open source graph drawing library that was much more convenient to use, although it does not let the user make their own graph types.   
*/

import java.awt.Graphics2D;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.Color;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.File;


import javax.imageio.ImageIO;

public class DrawCanvas{
	private int imageW;
	private int imageH;
	private BufferedImage bi;
	private Graphics2D canvas;
	public DrawCanvas(){
	}

	public DrawCanvas(int width, int height, String bgcolor){
		imageW = width;
		imageH = height;
		Color temp = Color.decode(bgcolor);
		bi = new BufferedImage(imageW, imageH, BufferedImage.TYPE_INT_ARGB);
		canvas = bi.createGraphics();
		canvas.setPaint(temp);
		canvas.fillRect(0, 0, width, height);
	}
	
	public void add_line(int x, int y, int length, float width, String direction, String color){
		Color temp = Color.decode(color);
		canvas.setPaint(temp);
		BasicStroke pen = new BasicStroke(width);
		canvas.setStroke(pen);
			
		if (direction.charAt(0) == 'v'){
			canvas.drawLine(x,imageH-y, x, imageH-(y+length));
		}
		else {
			canvas.drawLine(x, imageH-y, x+length, imageH-y);
		}
	}
	
	public void add_line_from_points(int sx, int sy, int ex, int ey, float width, String color){
		BasicStroke pen = new BasicStroke(width);
		canvas.setStroke(pen);
		Color temp = Color.decode(color);
		canvas.setPaint(temp);
		canvas.drawLine(sx, imageH-sy, ex, imageH-ey);
	}
	
	public void add_points(int x, int y, int width, String color){
		BasicStroke pen = new BasicStroke(1);
		canvas.setStroke(pen);
		Color temp = Color.decode(color);
		canvas.setPaint(temp);
		canvas.drawOval(x-width/2, imageH-(y+width/2), width, width);
		canvas.fillOval(x-width/2, imageH-(y+width/2), width, width);
	}
	
	public void add_circle(int x, int y, int radius, float width, String border, String fill){
		BasicStroke pen = new BasicStroke(width);
		canvas.setStroke(pen);	
		Color temp = Color.decode(border);
		canvas.setPaint(temp);
		canvas.drawOval(x-radius, imageH-y-radius, 2*radius, 2*radius);
		Color temp2 = Color.decode(fill);
		canvas.setPaint(temp2);
		canvas.fillOval(x-radius,imageH-y-radius, 2*radius, 2*radius);
	}
	

	public void add_rectangle(int x, int y, int width, int height, float pwidth, String border, String fill){
		BasicStroke pen = new BasicStroke(pwidth);
		canvas.setStroke(pen);	
		Color temp = Color.decode(border);
		canvas.setPaint(temp);
		canvas.drawRect(x, imageH-y, width, height);
		Color temp2 = Color.decode(fill);
		canvas.setPaint(temp2);
		canvas.fillRect(x, imageH-y, width, height);
	}
	
	public void add_label(int x, int y, String direction, int size, String label){
		if (direction.charAt(0) == 'h'){
			canvas.setPaint(Color.black);
			Font labelFont = new Font("TimesRoman", Font.BOLD, size);
			canvas.setFont(labelFont);
			canvas.drawString(label, x, imageH-y);
		}else {
			BufferedImage tempBI = new BufferedImage(20, 20, BufferedImage.TYPE_INT_ARGB);
			Graphics fontcanvas = tempBI.createGraphics();
			Font labelFont = new Font("TimesRoman", Font.BOLD, size);
			fontcanvas.setFont(labelFont);
			FontMetrics fm = fontcanvas.getFontMetrics();
			int fontHeight = fm.getMaxAscent();
			
			canvas.setPaint(Color.black);
			canvas.setFont(labelFont);
			canvas.rotate(-90.0 * Math.PI / 180.0);
			canvas.drawString(label, y-imageH, x+fontHeight);
			canvas.rotate(90.0 * Math.PI / 180.0);
		}
	}
	
	public void write(String filename) throws Exception{
			ImageIO.write(bi, "PNG", new File(filename));
			
	}
	
}