/*
 * walker.g : the AST walker.
 *
 * @author Tiantian Zhou - tz2002@columbia.edu
 *
 * @version $Id: walker.g,v 1.24 2003/05/12 21:42:43 hanhua Exp $
 */

{
import java.io.*;
import java.util.*;
}

class MxAntlrWalker extends TreeParser;
options{
    importVocab = MxAntlr;
}

{
    static MxDataType null_data = new MxDataType( "<NULL>" );
    MxInterpreter ipt = new MxInterpreter();
}

expr returns [ MxDataType r ]
{
    MxDataType a, b;
    Vector v;
    MxDataType[] x;
    String s = null;
    String[] sx;
    r = null_data;
}
        : #("or" a=expr right_or:.)
            { 
                if ( a instanceof MxBool )
                    r = ( ((MxBool)a).var ? a : expr(#right_or) );
                else
                    r = a.or( expr(#right_or) );
            }
        | #("and" a=expr right_and:.) 
            {
                if ( a instanceof MxBool )
                    r = ( ((MxBool)a).var ? expr(#right_and) : a );
                else
                    r = a.and( expr(#right_and) );
            }
        | #("not" a=expr)            { r = a.not(); }
        | #(GE a=expr b=expr)        { r = a.ge( b ); }
        | #(LE a=expr b=expr)        { r = a.le( b ); }
        | #(GT a=expr b=expr)        { r = a.gt( b ); }
        | #(LT a=expr b=expr)        { r = a.lt( b ); }
        | #(EQ a=expr b=expr)        { r = a.eq( b ); }
        | #(NEQ a=expr b=expr)       { r = a.ne( b ); }
        | #(PLUS a=expr b=expr)      { r = a.plus( b ); }
        | #(MINUS a=expr b=expr)     { r = a.minus( b ); }
        | #(MULT a=expr b=expr)      { r = a.times( b ); }
        | #(LDV a=expr b=expr)       { r = a.lfracts( b ); }
        | #(RDV a=expr b=expr)       { r = a.rfracts( b ); }
        | #(MOD a=expr b=expr)       { r = a.modulus( b ); }
        | #(UPLUS a=expr)            { r = a; }
        | #(UMINUS a=expr)           { r = a.uminus(); }
        | #(PLUSEQ a=expr b=expr)    { r = a.add( b ); }
        | #(MINUSEQ a=expr b=expr)   { r = a.sub( b ); }
        | #(MULTEQ a=expr b=expr)    { r = a.mul( b ); }
        | #(LDVEQ a=expr b=expr)     { r = a.ldiv( b ); }
        | #(RDVEQ a=expr b=expr)     { r = a.rdiv( b ); }
        | #(MODEQ a=expr b=expr)     { r = a.rem( b ); }
        | #(COLON (c1:. (c2:.)?)?)
            {
                r = MxRange.create( (null==#c1) ? null : expr(#c1), 
                                    (null==#c2) ? null : expr(#c2) ); 
            }
        | #(DCOLON a=expr b=expr)    { r = MxRange.create( a, b, 1 ); }
        | #(ASGN a=expr b=expr)      { r = ipt.assign( a, b ); }
        | #(FUNC_CALL a=expr x=mexpr)
            { r = ipt.funcInvoke( this, a, x ); }
        | #(ARRAY                    { v = new Vector(); } 
             (a=expr                 { v.add( a ); } 
             )*
           ) 
            { r = MxMatrix.joinVert( ipt.convertExprList( v ) ); }
        | #(ARRAY_ROW                { v = new Vector(); } 
             (a=expr                 { v.add( a ); } 
             )+
           )
            { r = MxMatrix.joinHori( ipt.convertExprList( v ) ); }
        | num:NUMBER                 { r = ipt.getNumber( num.getText() ); }
        | str:STRING                 { r = new MxString( str.getText() ); }
        | "true"                     { r = new MxBool( true ); }
        | "false"                    { r = new MxBool( false ); }
        | #(id:ID                    { r = ipt.getVariable( id.getText() ); } 
              ( x=mexpr              { r = ipt.subMatrix( r, x ); } 
              )*
           ) 
        | #(TRSP a=expr)             { r = a.transpose(); }
        | #("for" x=mexpr forbody:.) 
            { 
                MxInt[] values = ipt.forInit( x );
                while ( ipt.forCanProceed( x, values ) ) 
                {
                    r = expr( #forbody );
                    ipt.forNext( x, values );
                }
                ipt.forEnd( x );
            }
        | #("if" a=expr thenp:. (elsep:.)?)
            {
                if ( !( a instanceof MxBool ) )
                    return a.error( "if: expression should be bool" );
                if ( ((MxBool)a).var )
                    r = expr( #thenp );
                else if ( null != elsep )
                    r = expr( #elsep );
            }
        | #(STATEMENT (stmt:. { if ( ipt.canProceed() ) r = expr(#stmt); } )*)
        | #(LOOP loopbody:.
                   (loopid:ID        { s = loopid.getText(); }
                   )?
           )
            {
                while ( ipt.canProceed() ) 
                {
                    r = expr( #loopbody );
                    ipt.loopNext( s );
                }
                ipt.loopEnd( s );
            }
        | #("break" (breakid:ID      { s = breakid.getText(); }
                    )? 
           )                         { ipt.setBreak( s ); }
        | #("continue" (contid:ID    { s = contid.getText(); }
                       )?
           )                         { ipt.setContinue( s ); }
        | #("return" ( a=expr        { r = ipt.rvalue( a ); }
                     )?
           )                         { ipt.setReturn( null ); }
        | #("func" fname:ID sx=vlist fbody:.) 
            { ipt.funcRegister( fname.getText(), sx, #fbody ); }
        | #("include" a=expr)        { ipt.include( a ); }
        ;

mexpr returns [ MxDataType[] rv ]
{
    MxDataType a;
    rv = null;
    Vector v;
}
        : #(EXPR_LIST         { v = new Vector(); } 
                ( a=expr      { v.add( a ); } 
                )* 
           )                  { rv = ipt.convertExprList( v ); }
        | a=expr              { rv = new MxDataType[1]; rv[0] = a; }
        |  #(FOR_CON          { v = new Vector(); } 
                ( s:ID a=expr { a.setName( s.getText() ); v.add(a); } 
                )+
            )                 { rv = ipt.convertExprList( v ); }
        ;

vlist returns [ String[] sv ]
{
    Vector v;
    sv = null;
}
        : #(VAR_LIST     { v = new Vector(); }
              (s:ID      { v.add( s.getText() ); }
              )*
          )              { sv = ipt.convertVarList( v ); }
        ;


