import java.io.PrintWriter;

/**
 * the wrapper class for string
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxString.java,v 1.6 2003/05/12 23:44:34 hanhua Exp $
 */
class MxString extends MxDataType {
    String var;

    public MxString( String str ) {
        this.var = str;
    }

    public String typename() {
        return "string";
    }

    public MxDataType copy() {
        return new MxString( var );
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.print( var );
        w.println();
    }

    public MxDataType plus( MxDataType b ) {
        if ( b instanceof MxString )
            return new MxString( var + ((MxString)b).var );

        return error( b, "+" );
    }

    public MxDataType add( MxDataType b ) {
        if ( b instanceof MxString )
        {
            var = var + ((MxString)b).var;
            return this;
        }

        return error( b, "+=" );
    }    
}
