import java.io.PrintWriter;
import jamaica.BitArray;

/**
 * the wrapper class for jamaica.BitArray
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxBitArray.java,v 1.12 2003/05/12 23:44:34 hanhua Exp $
 */
class MxBitArray extends MxDataType {
    BitArray ba;

    public MxBitArray( BitArray ba ) {
        this.ba = ba;
    }

    public String typename() {
        return "matmask";
    }

    public MxDataType copy() {
        return new MxBitArray( ba );
    }

    public void print( PrintWriter w ) {
        if ( name != null )
            w.print( name + " = " );
        w.print( ba.toString() );
        w.println();
    }

    public MxDataType and( MxDataType b ) {
        if ( b instanceof MxBitArray )
            return new MxBitArray( ba.and( ((MxBitArray)b).ba ) );
        return error( b, "and" );
    }

    public MxDataType or( MxDataType b ) {
        if ( b instanceof MxBitArray )
            return new MxBitArray( ba.or( ((MxBitArray)b).ba ) );
        return error( b, "or" );
    }

    public MxDataType not() {
        return new MxBitArray( ba.not() );
    }
}
