divert(-1)
define(FOREACH,`pushdef(`$1', `')pushdef(`$3', `$4')dnl
_foreach(`$1', `$2', `$3', `$4', `$5')popdef(`$3')popdef(`$1')')
define(_arg1,`$1')
define(_foreach, 
   `ifelse(`$2', `()', ,
	`define(`$1', _arg1$2)$5`'define(`$3',incr($3))dnl
_foreach(`$1', (shift$2), `$3', `$4', `$5')')')

define(EXCEPTION,`throw new MxException( "$1() accepts $2 parameter(s)" );')

define(CHECK_NR_PARAM,`if ( params.length != $2 )
                EXCEPTION( $1, $2 );')

define(CASE_MATRIXOP1,`case f_$1:
            CHECK_NR_PARAM( inv, 1 )
            if ( ! (params[0] instanceof MxMatrix ) )
                return params[0].error( "$1" );
            return new $3( ((MxMatrix)params[0]).mat.$2() );
')            

define(CASE_MINMAX,`case f_$1:
            if ( params.length > 0 )
            {
                if ( isIntList( params ) )
                {
                    int x = MxInt.intValue( params[0] );
                    for ( int i=1; i<params.length; i++ )
                    {
                        int y = MxInt.intValue( params[i] );
                        if ( y $2 x )
                            x = y;
                    }
                    return new MxInt( x );
                }

                double x = ( (params[0] instanceof MxMatrix)?
                             ((MxMatrix)params[0]).mat.$1()
                             : MxDouble.doubleValue( params[0] ) );
                for ( int i=1; i<params.length; i++ )
                {
                    double y = ( (params[i] instanceof MxMatrix)?
                                 ((MxMatrix)params[i]).mat.$1()
                                 : MxDouble.doubleValue( params[i] ) );
                    if ( y $2 x )
                        x = y;
                }
                return new MxDouble( x );
            }
            EXCEPTION( $1, 1 )
')

define(CASE_VECOP1,`case f_$1:
            CHECK_NR_PARAM( $1, 1 )
            if ( params[0] instanceof MxMatrix )
            {
                Matrix p = ((MxMatrix)params[0]).mat;
                int m = p.height(), n = p.width();
                Matrix x = new Matrix( m, n );
                for ( int j=0; j<n; j++ )
                    for ( int i=0; i<m; i++ )
                        x.set( i, j, $2( p.get(i,j) ) );
                return new MxMatrix( x );
            }
            return new MxDouble( 
                $2( MxDouble.doubleValue( params[0] ) ) );
')

define(CASE_DIM,`case f_$1:
            CHECK_NR_PARAM( $1, 1 )
            if ( params[0] instanceof MxMatrix )
                return new MxInt( ((MxMatrix)params[0]).mat.$2() );
            return new MxInt( 0 );
')

define(CASE_MULDIV,`case f_$1:
            CHECK_NR_PARAM( $1, 2 )
            if ( params[0] instanceof MxMatrix 
                 && params[1] instanceof MxMatrix )
            {
                return new MxMatrix( 
                    ((MxMatrix)params[0]).mat.$2( 
                        ((MxMatrix)params[1]).mat ) );
            }
            throw new MxException( "$1: arguments should be matricies" );
')

define(FUNCTIONS,`( print, what, plot, oplot, paint, opaint,
                    colormap, color,
                    load, save, width, height,
                    random, zeros, eye, indgen,
                    inv, det, flip, mirror,
                    min, max,
                    mul, div,
                    count,
                    round, floor, ceil, int, abs,
                    sqrt, exp, log, pow, sin, cos, tan, asin, acos, atan )')
divert

import java.util.Random;
import java.io.IOException;
import jamaica.*;

/** The internal functions: MxInternalFunction.java is generated by
 * MxInternalFunction.m4
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxInternalFunction.m4,v 1.13 2003/05/13 23:25:22 hanhua Exp $
 */
class MxInternalFunction {
    static Random random = new Random();
    static int[] rgbtable = Painter.colorMap( Painter.CM_GRAYSCALE );
    static int defcolor = 0;
    static Painter painter = null;
    static Plotter plotter = null;

    /* if there is no rgbtable, generate an length-1 table from defcolor */
    private static int[] getRGBTable() {
        if ( null != rgbtable )
            return rgbtable;
        return new int[]{ defcolor };
    }

FOREACH( NAME, FUNCTIONS, INDEX, 0, `
    final static int f_`'NAME = INDEX;define(INDEX,incr(INDEX))')

    public static void register( MxSymbolTable st ) {
FOREACH( NAME, FUNCTIONS, INDEX, `0', `
              st.put( "NAME", new MxFunction( null, f_`'NAME ) );' )
        st.put( "E", new MxDouble( Math.E ) );
        st.put( "PI", new MxDouble( Math.PI ) );
    }

    private static boolean isIntList( MxDataType[] params ){
        for ( int i=0; i<params.length; i++ )
            if ( ! ( params[i] instanceof MxInt ) )
                return false;
        return true;
    }

    public static MxDataType run( MxSymbolTable st,
                                  int id, MxDataType[] params ) {
        switch ( id )
        {
        case f_print:
            for ( int i=0; i<params.length; i++ )
                params[i].print();
            return null;

        case f_what:
            if ( params.length > 0 )
            {
                for ( int i=0; i<params.length; i++ )
                        params[i].what();
            }
            else
                st.what();
            return null;

        case f_paint:
            if ( params.length != 1 && params.length != 3 )
                EXCEPTION( paint, 1 or 3 )
            if ( !( params[0] instanceof MxMatrix ) )
                throw new MxException( "Only matrix can be drawn" );
            painter = Painter.create( "Mx Painter", 100, 100 );
            if ( 1 == params.length )
                painter.draw( ((MxMatrix)params[0]).mat, getRGBTable() );
            else
                painter.draw( ((MxMatrix)params[0]).mat, 
                    MxDouble.doubleValue( params[1] ),
                    MxDouble.doubleValue( params[2] ), getRGBTable() );
            return params[0];

        case f_opaint:
            if ( null == painter )
                throw new MxException( "No previous painting window" );
            if ( 0 == params.length )
                EXCEPTION( opaint, 1 or more )
            if ( !( params[0] instanceof MxMatrix ) )
                throw new MxException( "Only matrix can be drawn" );
            BitArray bmk = null;
            double min = 0.0, max = 0.0;
            int xpos = 0, ypos = 0;
            int offset = 1;
            if ( offset < params.length 
                 && ( params[offset] instanceof MxBitArray ) )
                bmk = ((MxBitArray)params[offset++]).ba;

            if ( offset < params.length-1 )
            {
                xpos = MxInt.intValue( params[offset++] );
                ypos = MxInt.intValue( params[offset++] );
            }
            if ( offset < params.length-1 )
            {
                min = MxDouble.doubleValue( params[offset++] );
                max = MxDouble.doubleValue( params[offset++] );
            }
            if ( offset < params.length )
                throw new MxException( "Additional arguments" );
            if ( max > min )
                painter.overdraw( ((MxMatrix)params[0]).mat, bmk, min, max,
                                   getRGBTable(), xpos, ypos );
            else
                painter.overdraw( ((MxMatrix)params[0]).mat, bmk, 
                                  getRGBTable(), xpos, ypos );
            return params[0];

        case f_plot:
            if ( 1 != params.length && 2 != params.length )
                EXCEPTION( plot, 1-2 );
            if ( !( params[0] instanceof MxMatrix ) )
                throw new MxException( "First arg should be a matrix" );
            plotter = Plotter.create( "Mx Plotter", 640, 480 );
            if ( 2 == params.length )
            {
                if ( !( params[1] instanceof MxMatrix ) )
                    throw new MxException( "Second arg should be a matrix" );
                Matrix mat = ((MxMatrix)params[1]).mat;
                double[] minmax = new double[6];
                minmax[0] = mat.get(0,0);
                minmax[1] = mat.get(1,0);
                minmax[2] = mat.get(0,1);
                minmax[3] = mat.get(1,1);
                if ( mat.width() >= 3 )
                {
                    minmax[4] = mat.get(0,2);
                    minmax[5] = mat.get(1,2);
                }
                plotter.draw( ((MxMatrix)params[0]).mat, 
                              minmax, defcolor, rgbtable );
            }
            else
                plotter.draw( ((MxMatrix)params[0]).mat, defcolor, rgbtable );
            return params[0];

        case f_color:
            CHECK_NR_PARAM( colors, 3 )
            defcolor = Painter.color( MxDouble.doubleValue( params[0] ),
                                      MxDouble.doubleValue( params[1] ),
                                      MxDouble.doubleValue( params[2] ) );
            return null;

        case f_colormap:
            if ( 0 == params.length )
            {
                rgbtable = null;
                return null;
            }

            CHECK_NR_PARAM( colors, 1 )
            if ( params[0] instanceof MxMatrix )
                rgbtable = Painter.colorMap( ((MxMatrix)params[0]).mat );
            else
                rgbtable = Painter.colorMap( MxInt.intValue( params[0] ) );
            return null;

        case f_load:
            if ( 4 != params.length && 5 != params.length )
                EXCEPTION( load, 4-5 )
            if ( ! (params[0] instanceof MxString 
                || params[1] instanceof MxString ) )
                throw new MxException( "First two args should be strings" );

            Matrix mat;
            try 
            {
                if ( params.length == 4 )
                    mat = Matrix.load( 
                        ((MxString)params[0]).var,
                        MxInterpreter.getDataType(((MxString)params[1]).var),
                        MxInt.intValue( params[2] ), 
                        MxInt.intValue( params[3] ) );
                else
                    mat = Matrix.load( ((MxString)params[0]).var,
                        MxInterpreter.getDataType(((MxString)params[1]).var),
                        MxInt.intValue( params[2] ), 
                        MxInt.intValue( params[3] ),
                        MxInt.intValue( params[4] ) );
            }
            catch ( IOException e )
            {
                throw new MxException( "I/O Exception:" + e );
            }

            if ( null == mat )
                throw new MxException( "File not found: " 
                                       + ((MxString)params[0]).var );
            return new MxMatrix( mat );

        case f_save:
            if ( 3 != params.length && 4 != params.length )
                EXCEPTION( save, 3-4 )
            if ( ! (params[0] instanceof MxMatrix) )
                throw new MxException( "Arg 1 should be a matrix" );
            if ( ! (params[1] instanceof MxString 
                || params[2] instanceof MxString ) )
                throw new MxException( "Args 2 and 3 should be strings" );
            try
            {
                if ( params.length == 3 )
                    ((MxMatrix)params[0]).mat.save(
                        ((MxString)params[1]).var,
                        MxInterpreter.getDataType(((MxString)params[2]).var) );
                else
                    ((MxMatrix)params[0]).mat.save(
                        ((MxString)params[1]).var,
                        MxInterpreter.getDataType( ((MxString)params[2]).var),
                        MxInt.intValue( params[3] ) );
            }
            catch ( IOException e )
            {
                throw new MxException( "I/O Exception:" + e );
            }
            return params[0];

        CASE_DIM( width, width )
        CASE_DIM( height, height )

        case f_random:
            if ( 0 == params.length )
                return new MxDouble( random.nextDouble() );
            if ( 1 == params.length )
            {
                if ( params[0] instanceof MxDouble )
                    return new MxDouble( random.nextDouble()
                                         * MxDouble.doubleValue( params[0] ) );

                if ( params[0] instanceof MxInt )
                    return new MxInt( random.nextInt( 
                                          MxInt.intValue( params[0] ) ) );
            }
            else if ( 2 == params.length )
                return new MxMatrix( Matrix.random( 
                                         MxInt.intValue( params[0] ),
                                         MxInt.intValue( params[1] ) ) );
            EXCEPTION( random, 0-2 )

        case f_zeros:
            CHECK_NR_PARAM( zeros, 2 )
            return new MxMatrix( 
                new Matrix( MxInt.intValue( params[0] ), 
                            MxInt.intValue( params[1] ) ) );

        case f_eye:
            CHECK_NR_PARAM( eye, 1 )
            return new MxMatrix( Matrix.eye( MxInt.intValue( params[0] ) ) );

        case f_indgen:
            CHECK_NR_PARAM( indgen, 5 );
            return new MxMatrix( Matrix.indgen(
                MxInt.intValue( params[0] ),
                MxInt.intValue( params[1] ),
                MxDouble.doubleValue( params[2] ),
                MxDouble.doubleValue( params[3] ),
                MxDouble.doubleValue( params[4] ) ) );

        CASE_MATRIXOP1( inv, invert, MxMatrix )
        CASE_MATRIXOP1( det, det, MxDouble )
        CASE_MATRIXOP1( flip, flip, MxMatrix )
        CASE_MATRIXOP1( mirror, mirror, MxMatrix )

        CASE_MINMAX( min, `<' )
        CASE_MINMAX( max, `>' )

        CASE_MULDIV( mul, etimes )
        CASE_MULDIV( div, edivide )

        case f_pow:
            CHECK_NR_PARAM( $1, 2 )
            double pwr = MxDouble.doubleValue( params[1] );

            if ( params[0] instanceof MxMatrix )
            {
                Matrix p = ((MxMatrix)params[0]).mat;
                int m = p.height(), n = p.width();
                Matrix x = new Matrix( m, n );
                for ( int j=0; j<n; j++ )
                    for ( int i=0; i<m; i++ )
                        x.set( i, j, Math.pow( p.get(i,j), pwr ) );
                return new MxMatrix( x );
            }
            return new MxDouble( 
                Math.pow( MxDouble.doubleValue( params[0] ), pwr ) );

        case f_count:
            CHECK_NR_PARAM( $1, 1 );
            if ( params[0] instanceof MxBitArray )
                return new MxInt( ((MxBitArray)params[0]).ba.count() );
            throw new MxException( "count() accepts one bitmask argument" );

        CASE_VECOP1( round, Math.round )
        CASE_VECOP1( ceil, Math.ceil )
        CASE_VECOP1( floor, Math.floor )
        CASE_VECOP1( abs, Math.abs )
        CASE_VECOP1( sqrt, Math.sqrt )
        CASE_VECOP1( exp, Math.exp )
        CASE_VECOP1( log, Math.log )
        CASE_VECOP1( sin, Math.sin )
        CASE_VECOP1( cos, Math.cos )
        CASE_VECOP1( tan, Math.tan )
        CASE_VECOP1( asin, Math.asin )
        CASE_VECOP1( acos, Math.acos )
        CASE_VECOP1( atan, Math.atan )
 
        default:
            throw new MxException( "unknown internal function" );
        }
    }

}