// $ANTLR 2.7.2: "grammar.g" -> "MxAntlrParser.java"$

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import java.util.Hashtable;
import antlr.ASTFactory;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

public class MxAntlrParser extends antlr.LLkParser       implements MxAntlrTokenTypes
 {

    int nr_error = 0;
    public void reportError( String s ) {
        super.reportError( s );
        nr_error++;
    }
    public void reportError( RecognitionException e ) {
        super.reportError( e );
        nr_error++;
    }

protected MxAntlrParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public MxAntlrParser(TokenBuffer tokenBuf) {
  this(tokenBuf,2);
}

protected MxAntlrParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

public MxAntlrParser(TokenStream lexer) {
  this(lexer,2);
}

public MxAntlrParser(ParserSharedInputState state) {
  super(state,2);
  tokenNames = _tokenNames;
  buildTokenTypeASTClassMap();
  astFactory = new ASTFactory(getTokenTypeToASTClassMap());
}

	public final void program() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST program_AST = null;
		
		try {      // for error handling
			{
			_loop73:
			do {
				switch ( LA(1)) {
				case LBRACE:
				case ID:
				case LITERAL_for:
				case LITERAL_if:
				case LITERAL_loop:
				case LITERAL_break:
				case LITERAL_continue:
				case LITERAL_return:
				case LITERAL_include:
				{
					statement();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case LITERAL_func:
				{
					func_def();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					break _loop73;
				}
				}
			} while (true);
			}
			match(Token.EOF_TYPE);
			program_AST = (AST)currentAST.root;
			program_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(STATEMENT,"PROG")).add(program_AST));
			currentAST.root = program_AST;
			currentAST.child = program_AST!=null &&program_AST.getFirstChild()!=null ?
				program_AST.getFirstChild() : program_AST;
			currentAST.advanceChildToEnd();
			program_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_0);
		}
		returnAST = program_AST;
	}
	
	public final void statement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST statement_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LITERAL_for:
			{
				for_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_if:
			{
				if_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_loop:
			{
				loop_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_break:
			{
				break_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_continue:
			{
				continue_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_return:
			{
				return_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_include:
			{
				load_stmt();
				astFactory.addASTChild(currentAST, returnAST);
				statement_AST = (AST)currentAST.root;
				break;
			}
			case LBRACE:
			{
				match(LBRACE);
				{
				_loop76:
				do {
					if ((_tokenSet_1.member(LA(1)))) {
						statement();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop76;
					}
					
				} while (true);
				}
				match(RBRACE);
				statement_AST = (AST)currentAST.root;
				statement_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(STATEMENT,"STATEMENT")).add(statement_AST));
				currentAST.root = statement_AST;
				currentAST.child = statement_AST!=null &&statement_AST.getFirstChild()!=null ?
					statement_AST.getFirstChild() : statement_AST;
				currentAST.advanceChildToEnd();
				statement_AST = (AST)currentAST.root;
				break;
			}
			default:
				if ((LA(1)==ID) && (_tokenSet_2.member(LA(2)))) {
					assignment();
					astFactory.addASTChild(currentAST, returnAST);
					statement_AST = (AST)currentAST.root;
				}
				else if ((LA(1)==ID) && (LA(2)==LPAREN)) {
					func_call_stmt();
					astFactory.addASTChild(currentAST, returnAST);
					statement_AST = (AST)currentAST.root;
				}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = statement_AST;
	}
	
	public final void func_def() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST func_def_AST = null;
		
		try {      // for error handling
			AST tmp4_AST = null;
			tmp4_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp4_AST);
			match(LITERAL_func);
			AST tmp5_AST = null;
			tmp5_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp5_AST);
			match(ID);
			match(LPAREN);
			var_list();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			func_body();
			astFactory.addASTChild(currentAST, returnAST);
			func_def_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_4);
		}
		returnAST = func_def_AST;
	}
	
	public final void for_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST for_stmt_AST = null;
		
		try {      // for error handling
			AST tmp8_AST = null;
			tmp8_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp8_AST);
			match(LITERAL_for);
			match(LPAREN);
			for_con();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			statement();
			astFactory.addASTChild(currentAST, returnAST);
			for_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = for_stmt_AST;
	}
	
	public final void if_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST if_stmt_AST = null;
		
		try {      // for error handling
			AST tmp11_AST = null;
			tmp11_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp11_AST);
			match(LITERAL_if);
			match(LPAREN);
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			statement();
			astFactory.addASTChild(currentAST, returnAST);
			{
			if ((LA(1)==LITERAL_else) && (_tokenSet_1.member(LA(2)))) {
				match(LITERAL_else);
				statement();
				astFactory.addASTChild(currentAST, returnAST);
			}
			else if ((_tokenSet_3.member(LA(1))) && (_tokenSet_5.member(LA(2)))) {
			}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			
			}
			if_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = if_stmt_AST;
	}
	
	public final void loop_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST loop_stmt_AST = null;
		Token  id = null;
		AST id_AST = null;
		AST stmt_AST = null;
		
		try {      // for error handling
			match(LITERAL_loop);
			{
			switch ( LA(1)) {
			case LPAREN:
			{
				match(LPAREN);
				id = LT(1);
				id_AST = astFactory.create(id);
				match(ID);
				match(RPAREN);
				break;
			}
			case LBRACE:
			case ID:
			case LITERAL_for:
			case LITERAL_if:
			case LITERAL_loop:
			case LITERAL_break:
			case LITERAL_continue:
			case LITERAL_return:
			case LITERAL_include:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			statement();
			stmt_AST = (AST)returnAST;
			loop_stmt_AST = (AST)currentAST.root;
			
			if ( null == id_AST )
			loop_stmt_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(LOOP,"loop")).add(stmt_AST));
			else
			loop_stmt_AST = (AST)astFactory.make( (new ASTArray(3)).add(astFactory.create(LOOP,"loop")).add(stmt_AST).add(id_AST));
			
			currentAST.root = loop_stmt_AST;
			currentAST.child = loop_stmt_AST!=null &&loop_stmt_AST.getFirstChild()!=null ?
				loop_stmt_AST.getFirstChild() : loop_stmt_AST;
			currentAST.advanceChildToEnd();
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = loop_stmt_AST;
	}
	
	public final void break_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST break_stmt_AST = null;
		
		try {      // for error handling
			AST tmp18_AST = null;
			tmp18_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp18_AST);
			match(LITERAL_break);
			{
			switch ( LA(1)) {
			case ID:
			{
				AST tmp19_AST = null;
				tmp19_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp19_AST);
				match(ID);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			break_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = break_stmt_AST;
	}
	
	public final void continue_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST continue_stmt_AST = null;
		
		try {      // for error handling
			AST tmp21_AST = null;
			tmp21_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp21_AST);
			match(LITERAL_continue);
			{
			switch ( LA(1)) {
			case ID:
			{
				AST tmp22_AST = null;
				tmp22_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp22_AST);
				match(ID);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			continue_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = continue_stmt_AST;
	}
	
	public final void return_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST return_stmt_AST = null;
		
		try {      // for error handling
			AST tmp24_AST = null;
			tmp24_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp24_AST);
			match(LITERAL_return);
			{
			switch ( LA(1)) {
			case LPAREN:
			case PLUS:
			case MINUS:
			case LBRK:
			case ID:
			case NUMBER:
			case STRING:
			case LITERAL_not:
			case LITERAL_true:
			case LITERAL_false:
			{
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case SEMI:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(SEMI);
			return_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = return_stmt_AST;
	}
	
	public final void load_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST load_stmt_AST = null;
		
		try {      // for error handling
			AST tmp26_AST = null;
			tmp26_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp26_AST);
			match(LITERAL_include);
			AST tmp27_AST = null;
			tmp27_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp27_AST);
			match(STRING);
			match(SEMI);
			load_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = load_stmt_AST;
	}
	
	public final void assignment() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST assignment_AST = null;
		
		try {      // for error handling
			l_value();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case ASGN:
			{
				AST tmp29_AST = null;
				tmp29_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp29_AST);
				match(ASGN);
				break;
			}
			case PLUSEQ:
			{
				AST tmp30_AST = null;
				tmp30_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp30_AST);
				match(PLUSEQ);
				break;
			}
			case MINUSEQ:
			{
				AST tmp31_AST = null;
				tmp31_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp31_AST);
				match(MINUSEQ);
				break;
			}
			case MULTEQ:
			{
				AST tmp32_AST = null;
				tmp32_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp32_AST);
				match(MULTEQ);
				break;
			}
			case LDVEQ:
			{
				AST tmp33_AST = null;
				tmp33_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp33_AST);
				match(LDVEQ);
				break;
			}
			case MODEQ:
			{
				AST tmp34_AST = null;
				tmp34_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp34_AST);
				match(MODEQ);
				break;
			}
			case RDVEQ:
			{
				AST tmp35_AST = null;
				tmp35_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp35_AST);
				match(RDVEQ);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			match(SEMI);
			assignment_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = assignment_AST;
	}
	
	public final void func_call_stmt() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST func_call_stmt_AST = null;
		
		try {      // for error handling
			func_call();
			astFactory.addASTChild(currentAST, returnAST);
			match(SEMI);
			func_call_stmt_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_3);
		}
		returnAST = func_call_stmt_AST;
	}
	
	public final void for_con() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST for_con_AST = null;
		
		try {      // for error handling
			AST tmp38_AST = null;
			tmp38_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp38_AST);
			match(ID);
			match(ASGN);
			range();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop80:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					AST tmp41_AST = null;
					tmp41_AST = astFactory.create(LT(1));
					astFactory.addASTChild(currentAST, tmp41_AST);
					match(ID);
					match(ASGN);
					range();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop80;
				}
				
			} while (true);
			}
			for_con_AST = (AST)currentAST.root;
			for_con_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FOR_CON,"FOR_CON")).add(for_con_AST));
			currentAST.root = for_con_AST;
			currentAST.child = for_con_AST!=null &&for_con_AST.getFirstChild()!=null ?
				for_con_AST.getFirstChild() : for_con_AST;
			currentAST.advanceChildToEnd();
			for_con_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_6);
		}
		returnAST = for_con_AST;
	}
	
	public final void range() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST range_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LPAREN:
			case PLUS:
			case MINUS:
			case LBRK:
			case ID:
			case NUMBER:
			case STRING:
			case LITERAL_not:
			case LITERAL_true:
			case LITERAL_false:
			{
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				{
				switch ( LA(1)) {
				case COLON:
				{
					AST tmp43_AST = null;
					tmp43_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp43_AST);
					match(COLON);
					{
					switch ( LA(1)) {
					case LPAREN:
					case PLUS:
					case MINUS:
					case LBRK:
					case ID:
					case NUMBER:
					case STRING:
					case LITERAL_not:
					case LITERAL_true:
					case LITERAL_false:
					{
						expression();
						astFactory.addASTChild(currentAST, returnAST);
						break;
					}
					case RPAREN:
					case RBRK:
					case COMMA:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					break;
				}
				case DCOLON:
				{
					AST tmp44_AST = null;
					tmp44_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp44_AST);
					match(DCOLON);
					expression();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case RPAREN:
				case RBRK:
				case COMMA:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				range_AST = (AST)currentAST.root;
				break;
			}
			case COLON:
			{
				AST tmp45_AST = null;
				tmp45_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp45_AST);
				match(COLON);
				range_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_7);
		}
		returnAST = range_AST;
	}
	
	public final void expression() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expression_AST = null;
		
		try {      // for error handling
			logic_term();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop108:
			do {
				if ((LA(1)==LITERAL_or)) {
					AST tmp46_AST = null;
					tmp46_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp46_AST);
					match(LITERAL_or);
					logic_term();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop108;
				}
				
			} while (true);
			}
			expression_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_8);
		}
		returnAST = expression_AST;
	}
	
	public final void l_value() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST l_value_AST = null;
		
		try {      // for error handling
			AST tmp47_AST = null;
			tmp47_AST = astFactory.create(LT(1));
			astFactory.makeASTRoot(currentAST, tmp47_AST);
			match(ID);
			{
			_loop131:
			do {
				if ((LA(1)==LBRK)) {
					match(LBRK);
					index();
					astFactory.addASTChild(currentAST, returnAST);
					match(RBRK);
				}
				else {
					break _loop131;
				}
				
			} while (true);
			}
			l_value_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_9);
		}
		returnAST = l_value_AST;
	}
	
	public final void func_call() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST func_call_AST = null;
		
		try {      // for error handling
			AST tmp50_AST = null;
			tmp50_AST = astFactory.create(LT(1));
			astFactory.addASTChild(currentAST, tmp50_AST);
			match(ID);
			match(LPAREN);
			expr_list();
			astFactory.addASTChild(currentAST, returnAST);
			match(RPAREN);
			func_call_AST = (AST)currentAST.root;
			func_call_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(FUNC_CALL,"FUNC_CALL")).add(func_call_AST));
			currentAST.root = func_call_AST;
			currentAST.child = func_call_AST!=null &&func_call_AST.getFirstChild()!=null ?
				func_call_AST.getFirstChild() : func_call_AST;
			currentAST.advanceChildToEnd();
			func_call_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_10);
		}
		returnAST = func_call_AST;
	}
	
	public final void expr_list() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST expr_list_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LPAREN:
			case PLUS:
			case MINUS:
			case LBRK:
			case ID:
			case NUMBER:
			case STRING:
			case LITERAL_not:
			case LITERAL_true:
			case LITERAL_false:
			{
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop98:
				do {
					if ((LA(1)==COMMA)) {
						match(COMMA);
						expression();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop98;
					}
					
				} while (true);
				}
				expr_list_AST = (AST)currentAST.root;
				expr_list_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR_LIST,"EXPR_LIST")).add(expr_list_AST));
				currentAST.root = expr_list_AST;
				currentAST.child = expr_list_AST!=null &&expr_list_AST.getFirstChild()!=null ?
					expr_list_AST.getFirstChild() : expr_list_AST;
				currentAST.advanceChildToEnd();
				expr_list_AST = (AST)currentAST.root;
				break;
			}
			case RPAREN:
			{
				expr_list_AST = (AST)currentAST.root;
				expr_list_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR_LIST,"EXPR_LIST")).add(expr_list_AST));
				currentAST.root = expr_list_AST;
				currentAST.child = expr_list_AST!=null &&expr_list_AST.getFirstChild()!=null ?
					expr_list_AST.getFirstChild() : expr_list_AST;
				currentAST.advanceChildToEnd();
				expr_list_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_6);
		}
		returnAST = expr_list_AST;
	}
	
	public final void var_list() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST var_list_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID:
			{
				AST tmp54_AST = null;
				tmp54_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp54_AST);
				match(ID);
				{
				_loop102:
				do {
					if ((LA(1)==COMMA)) {
						match(COMMA);
						AST tmp56_AST = null;
						tmp56_AST = astFactory.create(LT(1));
						astFactory.addASTChild(currentAST, tmp56_AST);
						match(ID);
					}
					else {
						break _loop102;
					}
					
				} while (true);
				}
				var_list_AST = (AST)currentAST.root;
				var_list_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(VAR_LIST,"VAR_LIST")).add(var_list_AST));
				currentAST.root = var_list_AST;
				currentAST.child = var_list_AST!=null &&var_list_AST.getFirstChild()!=null ?
					var_list_AST.getFirstChild() : var_list_AST;
				currentAST.advanceChildToEnd();
				var_list_AST = (AST)currentAST.root;
				break;
			}
			case RPAREN:
			{
				var_list_AST = (AST)currentAST.root;
				var_list_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(VAR_LIST,"VAR_LIST")).add(var_list_AST));
				currentAST.root = var_list_AST;
				currentAST.child = var_list_AST!=null &&var_list_AST.getFirstChild()!=null ?
					var_list_AST.getFirstChild() : var_list_AST;
				currentAST.advanceChildToEnd();
				var_list_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_6);
		}
		returnAST = var_list_AST;
	}
	
	public final void func_body() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST func_body_AST = null;
		AST a_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case ASGN:
			{
				match(ASGN);
				expression();
				a_AST = (AST)returnAST;
				astFactory.addASTChild(currentAST, returnAST);
				match(SEMI);
				func_body_AST = (AST)currentAST.root;
				func_body_AST = a_AST;
				currentAST.root = func_body_AST;
				currentAST.child = func_body_AST!=null &&func_body_AST.getFirstChild()!=null ?
					func_body_AST.getFirstChild() : func_body_AST;
				currentAST.advanceChildToEnd();
				func_body_AST = (AST)currentAST.root;
				break;
			}
			case LBRACE:
			{
				match(LBRACE);
				{
				_loop105:
				do {
					if ((_tokenSet_1.member(LA(1)))) {
						statement();
						astFactory.addASTChild(currentAST, returnAST);
					}
					else {
						break _loop105;
					}
					
				} while (true);
				}
				match(RBRACE);
				func_body_AST = (AST)currentAST.root;
				func_body_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(STATEMENT,"FUNC_BODY")).add(func_body_AST));
				currentAST.root = func_body_AST;
				currentAST.child = func_body_AST!=null &&func_body_AST.getFirstChild()!=null ?
					func_body_AST.getFirstChild() : func_body_AST;
				currentAST.advanceChildToEnd();
				func_body_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_4);
		}
		returnAST = func_body_AST;
	}
	
	public final void logic_term() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logic_term_AST = null;
		
		try {      // for error handling
			logic_factor();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop111:
			do {
				if ((LA(1)==LITERAL_and)) {
					AST tmp61_AST = null;
					tmp61_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp61_AST);
					match(LITERAL_and);
					logic_factor();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop111;
				}
				
			} while (true);
			}
			logic_term_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_11);
		}
		returnAST = logic_term_AST;
	}
	
	public final void logic_factor() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST logic_factor_AST = null;
		
		try {      // for error handling
			{
			switch ( LA(1)) {
			case LITERAL_not:
			{
				AST tmp62_AST = null;
				tmp62_AST = astFactory.create(LT(1));
				astFactory.makeASTRoot(currentAST, tmp62_AST);
				match(LITERAL_not);
				break;
			}
			case LPAREN:
			case PLUS:
			case MINUS:
			case LBRK:
			case ID:
			case NUMBER:
			case STRING:
			case LITERAL_true:
			case LITERAL_false:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			relat_expr();
			astFactory.addASTChild(currentAST, returnAST);
			logic_factor_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_12);
		}
		returnAST = logic_factor_AST;
	}
	
	public final void relat_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST relat_expr_AST = null;
		
		try {      // for error handling
			arith_expr();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case GE:
			case LE:
			case GT:
			case LT:
			case EQ:
			case NEQ:
			{
				{
				switch ( LA(1)) {
				case GE:
				{
					AST tmp63_AST = null;
					tmp63_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp63_AST);
					match(GE);
					break;
				}
				case LE:
				{
					AST tmp64_AST = null;
					tmp64_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp64_AST);
					match(LE);
					break;
				}
				case GT:
				{
					AST tmp65_AST = null;
					tmp65_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp65_AST);
					match(GT);
					break;
				}
				case LT:
				{
					AST tmp66_AST = null;
					tmp66_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp66_AST);
					match(LT);
					break;
				}
				case EQ:
				{
					AST tmp67_AST = null;
					tmp67_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp67_AST);
					match(EQ);
					break;
				}
				case NEQ:
				{
					AST tmp68_AST = null;
					tmp68_AST = astFactory.create(LT(1));
					astFactory.makeASTRoot(currentAST, tmp68_AST);
					match(NEQ);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				arith_expr();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case RPAREN:
			case SEMI:
			case RBRK:
			case COMMA:
			case COLON:
			case DCOLON:
			case LITERAL_or:
			case LITERAL_and:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			relat_expr_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_12);
		}
		returnAST = relat_expr_AST;
	}
	
	public final void arith_expr() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arith_expr_AST = null;
		
		try {      // for error handling
			arith_term();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop120:
			do {
				if ((LA(1)==PLUS||LA(1)==MINUS)) {
					{
					switch ( LA(1)) {
					case PLUS:
					{
						AST tmp69_AST = null;
						tmp69_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp69_AST);
						match(PLUS);
						break;
					}
					case MINUS:
					{
						AST tmp70_AST = null;
						tmp70_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp70_AST);
						match(MINUS);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					arith_term();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop120;
				}
				
			} while (true);
			}
			arith_expr_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_13);
		}
		returnAST = arith_expr_AST;
	}
	
	public final void arith_term() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arith_term_AST = null;
		
		try {      // for error handling
			arith_factor();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop124:
			do {
				if ((_tokenSet_14.member(LA(1)))) {
					{
					switch ( LA(1)) {
					case MULT:
					{
						AST tmp71_AST = null;
						tmp71_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp71_AST);
						match(MULT);
						break;
					}
					case LDV:
					{
						AST tmp72_AST = null;
						tmp72_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp72_AST);
						match(LDV);
						break;
					}
					case MOD:
					{
						AST tmp73_AST = null;
						tmp73_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp73_AST);
						match(MOD);
						break;
					}
					case RDV:
					{
						AST tmp74_AST = null;
						tmp74_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp74_AST);
						match(RDV);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
					arith_factor();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop124;
				}
				
			} while (true);
			}
			arith_term_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_15);
		}
		returnAST = arith_term_AST;
	}
	
	public final void arith_factor() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST arith_factor_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case PLUS:
			{
				match(PLUS);
				r_value();
				astFactory.addASTChild(currentAST, returnAST);
				arith_factor_AST = (AST)currentAST.root;
				arith_factor_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(UPLUS,"UPLUS")).add(arith_factor_AST));
				currentAST.root = arith_factor_AST;
				currentAST.child = arith_factor_AST!=null &&arith_factor_AST.getFirstChild()!=null ?
					arith_factor_AST.getFirstChild() : arith_factor_AST;
				currentAST.advanceChildToEnd();
				arith_factor_AST = (AST)currentAST.root;
				break;
			}
			case MINUS:
			{
				match(MINUS);
				r_value();
				astFactory.addASTChild(currentAST, returnAST);
				arith_factor_AST = (AST)currentAST.root;
				arith_factor_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(UMINUS,"UMINUS")).add(arith_factor_AST));
				currentAST.root = arith_factor_AST;
				currentAST.child = arith_factor_AST!=null &&arith_factor_AST.getFirstChild()!=null ?
					arith_factor_AST.getFirstChild() : arith_factor_AST;
				currentAST.advanceChildToEnd();
				arith_factor_AST = (AST)currentAST.root;
				break;
			}
			case LPAREN:
			case LBRK:
			case ID:
			case NUMBER:
			case STRING:
			case LITERAL_true:
			case LITERAL_false:
			{
				r_value();
				astFactory.addASTChild(currentAST, returnAST);
				{
				_loop127:
				do {
					if ((LA(1)==TRSP)) {
						AST tmp77_AST = null;
						tmp77_AST = astFactory.create(LT(1));
						astFactory.makeASTRoot(currentAST, tmp77_AST);
						match(TRSP);
					}
					else {
						break _loop127;
					}
					
				} while (true);
				}
				arith_factor_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_16);
		}
		returnAST = arith_factor_AST;
	}
	
	public final void r_value() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST r_value_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case NUMBER:
			{
				AST tmp78_AST = null;
				tmp78_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp78_AST);
				match(NUMBER);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			case STRING:
			{
				AST tmp79_AST = null;
				tmp79_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp79_AST);
				match(STRING);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_true:
			{
				AST tmp80_AST = null;
				tmp80_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp80_AST);
				match(LITERAL_true);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_false:
			{
				AST tmp81_AST = null;
				tmp81_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp81_AST);
				match(LITERAL_false);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			case LBRK:
			{
				array();
				astFactory.addASTChild(currentAST, returnAST);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			case LPAREN:
			{
				match(LPAREN);
				expression();
				astFactory.addASTChild(currentAST, returnAST);
				match(RPAREN);
				r_value_AST = (AST)currentAST.root;
				break;
			}
			default:
				if ((LA(1)==ID) && (_tokenSet_17.member(LA(2)))) {
					l_value();
					astFactory.addASTChild(currentAST, returnAST);
					r_value_AST = (AST)currentAST.root;
				}
				else if ((LA(1)==ID) && (LA(2)==LPAREN)) {
					func_call();
					astFactory.addASTChild(currentAST, returnAST);
					r_value_AST = (AST)currentAST.root;
				}
			else {
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_10);
		}
		returnAST = r_value_AST;
	}
	
	public final void array() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST array_AST = null;
		
		try {      // for error handling
			match(LBRK);
			array_row();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop142:
			do {
				if ((LA(1)==SEMI)) {
					match(SEMI);
					array_row();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop142;
				}
				
			} while (true);
			}
			match(RBRK);
			array_AST = (AST)currentAST.root;
			array_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(ARRAY,"ARRAY")).add(array_AST));
			currentAST.root = array_AST;
			currentAST.child = array_AST!=null &&array_AST.getFirstChild()!=null ?
				array_AST.getFirstChild() : array_AST;
			currentAST.advanceChildToEnd();
			array_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_10);
		}
		returnAST = array_AST;
	}
	
	public final void index() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST index_AST = null;
		
		try {      // for error handling
			range();
			astFactory.addASTChild(currentAST, returnAST);
			{
			switch ( LA(1)) {
			case COMMA:
			{
				match(COMMA);
				range();
				astFactory.addASTChild(currentAST, returnAST);
				break;
			}
			case RBRK:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			index_AST = (AST)currentAST.root;
			index_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(EXPR_LIST,"INDEX")).add(index_AST));
			currentAST.root = index_AST;
			currentAST.child = index_AST!=null &&index_AST.getFirstChild()!=null ?
				index_AST.getFirstChild() : index_AST;
			currentAST.advanceChildToEnd();
			index_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_18);
		}
		returnAST = index_AST;
	}
	
	public final void array_row() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST array_row_AST = null;
		
		try {      // for error handling
			expression();
			astFactory.addASTChild(currentAST, returnAST);
			{
			_loop139:
			do {
				if ((LA(1)==COMMA)) {
					match(COMMA);
					expression();
					astFactory.addASTChild(currentAST, returnAST);
				}
				else {
					break _loop139;
				}
				
			} while (true);
			}
			array_row_AST = (AST)currentAST.root;
			array_row_AST = (AST)astFactory.make( (new ASTArray(2)).add(astFactory.create(ARRAY_ROW,"ARRAY_ROW")).add(array_row_AST));
			currentAST.root = array_row_AST;
			currentAST.child = array_row_AST!=null &&array_row_AST.getFirstChild()!=null ?
				array_row_AST.getFirstChild() : array_row_AST;
			currentAST.advanceChildToEnd();
			array_row_AST = (AST)currentAST.root;
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_19);
		}
		returnAST = array_row_AST;
	}
	
	public final void cl_statement() throws RecognitionException, TokenStreamException {
		
		returnAST = null;
		ASTPair currentAST = new ASTPair();
		AST cl_statement_AST = null;
		
		try {      // for error handling
			switch ( LA(1)) {
			case LBRACE:
			case ID:
			case LITERAL_for:
			case LITERAL_if:
			case LITERAL_loop:
			case LITERAL_break:
			case LITERAL_continue:
			case LITERAL_return:
			case LITERAL_include:
			case LITERAL_func:
			{
				{
				switch ( LA(1)) {
				case LBRACE:
				case ID:
				case LITERAL_for:
				case LITERAL_if:
				case LITERAL_loop:
				case LITERAL_break:
				case LITERAL_continue:
				case LITERAL_return:
				case LITERAL_include:
				{
					statement();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				case LITERAL_func:
				{
					func_def();
					astFactory.addASTChild(currentAST, returnAST);
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
				}
				cl_statement_AST = (AST)currentAST.root;
				break;
			}
			case LITERAL_exit:
			{
				AST tmp89_AST = null;
				tmp89_AST = astFactory.create(LT(1));
				astFactory.addASTChild(currentAST, tmp89_AST);
				match(LITERAL_exit);
				System.exit(0);
				cl_statement_AST = (AST)currentAST.root;
				break;
			}
			case EOF:
			{
				match(Token.EOF_TYPE);
				System.exit(0);
				cl_statement_AST = (AST)currentAST.root;
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (RecognitionException ex) {
			reportError(ex);
			consume();
			consumeUntil(_tokenSet_0);
		}
		returnAST = cl_statement_AST;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ALPHA",
		"DIGIT",
		"WS",
		"NL",
		"COMMENT",
		"LDV_LDVEQ",
		"LPAREN",
		"RPAREN",
		"MULT",
		"PLUS",
		"MINUS",
		"RDV",
		"MOD",
		"SEMI",
		"LBRACE",
		"RBRACE",
		"LBRK",
		"RBRK",
		"ASGN",
		"COMMA",
		"PLUSEQ",
		"MINUSEQ",
		"MULTEQ",
		"RDVEQ",
		"MODEQ",
		"GE",
		"LE",
		"GT",
		"LT",
		"EQ",
		"NEQ",
		"TRSP",
		"COLON",
		"DCOLON",
		"ID",
		"NUMBER",
		"STRING",
		"STATEMENT",
		"ARRAY_ROW",
		"ARRAY",
		"VAR_LIST",
		"EXPR_LIST",
		"FUNC_CALL",
		"FOR_CON",
		"LOOP",
		"UPLUS",
		"UMINUS",
		"\"for\"",
		"\"if\"",
		"\"else\"",
		"\"loop\"",
		"\"break\"",
		"\"continue\"",
		"\"return\"",
		"\"include\"",
		"LDVEQ",
		"\"func\"",
		"\"or\"",
		"\"and\"",
		"\"not\"",
		"LDV",
		"\"true\"",
		"\"false\"",
		"\"exit\""
	};
	
	protected void buildTokenTypeASTClassMap() {
		tokenTypeToASTClassMap=null;
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 2L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 565202028113166336L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	private static final long[] mk_tokenSet_2() {
		long[] data = { 576460752828760064L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
	private static final long[] mk_tokenSet_3() {
		long[] data = { 1727130731975278594L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
	private static final long[] mk_tokenSet_4() {
		long[] data = { 1718123532720013314L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
	private static final long[] mk_tokenSet_5() {
		long[] data = { -6919778902783138814L, 6L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
	private static final long[] mk_tokenSet_6() {
		long[] data = { 2048L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
	private static final long[] mk_tokenSet_7() {
		long[] data = { 10487808L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
	private static final long[] mk_tokenSet_8() {
		long[] data = { 206169049088L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());
	private static final long[] mk_tokenSet_9() {
		long[] data = { 7493990054820575232L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_9 = new BitSet(mk_tokenSet_9());
	private static final long[] mk_tokenSet_10() {
		long[] data = { 6917529301992863744L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_10 = new BitSet(mk_tokenSet_10());
	private static final long[] mk_tokenSet_11() {
		long[] data = { 2305843215382743040L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_11 = new BitSet(mk_tokenSet_11());
	private static final long[] mk_tokenSet_12() {
		long[] data = { 6917529233810130944L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_12 = new BitSet(mk_tokenSet_12());
	private static final long[] mk_tokenSet_13() {
		long[] data = { 6917529267632998400L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_13 = new BitSet(mk_tokenSet_13());
	private static final long[] mk_tokenSet_14() {
		long[] data = { 102400L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_14 = new BitSet(mk_tokenSet_14());
	private static final long[] mk_tokenSet_15() {
		long[] data = { 6917529267633022976L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_15 = new BitSet(mk_tokenSet_15());
	private static final long[] mk_tokenSet_16() {
		long[] data = { 6917529267633125376L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_16 = new BitSet(mk_tokenSet_16());
	private static final long[] mk_tokenSet_17() {
		long[] data = { 6917529301993912320L, 1L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_17 = new BitSet(mk_tokenSet_17());
	private static final long[] mk_tokenSet_18() {
		long[] data = { 2097152L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_18 = new BitSet(mk_tokenSet_18());
	private static final long[] mk_tokenSet_19() {
		long[] data = { 2228224L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_19 = new BitSet(mk_tokenSet_19());
	
	}
