#ifndef _SYSUTIL_H_
#define _SYSUTIL_H_
#ifdef __unix
#include <sys/time.h>
//#include <sys/types.h>
#else ifdef WIN32
#include <winsock2.h>
#endif

// to overcome problems on Solaris 2.5/2.6 and low-version C++ compilers
/*#ifndef bool
#define bool int
#endif

#ifndef socklen_t
#define socklen_t int
#endif*/

// abbreviation
#define SA struct sockaddr

extern char sysutil_errstr[256];

int new_server_sock(int type, u_short port);
int new_client_sock(int type, u_long dest_ip, u_short dest_port);
void init_sockaddr(struct sockaddr_in *sa, u_long ip_addr, u_short port);
void cleanup_socket(int &sock);

int readn(int fd, char *ptr, int nbytes);
int writenf(int sd, const char *fmt, ...); // like printf, work on sockets
int writen(int fd, char *ptr);
int writen(int fd, char *ptr, int nbytes);
int readline(int fd, char *ptr, int maxlen);

#ifndef USPS
#define USPS            1000000
#endif
struct timeval operator +(const struct timeval &a, const struct timeval &b);
struct timeval operator +(const struct timeval &a, int b);
struct timeval operator -(const struct timeval &a, const struct timeval &b);
bool operator >(const struct timeval &a, const struct timeval &b);
//inline struct timeval &operator =(struct timeval &a, int b)
//{ a.tv_sec = b; a.tv_usec = 0; return a; }
inline struct timeval to_timeval(int a)
{ struct timeval b; b.tv_sec = a; b.tv_usec = 0; return b; }
inline struct timeval to_timeval_usec(int usec)
{ struct timeval b; b.tv_sec = usec/USPS; b.tv_usec = usec%USPS; return b; }
inline struct timeval &operator +=(struct timeval &a, const struct timeval &b)
{ a = a + b; return a; }
inline struct timeval &operator +=(struct timeval &a, int b)
{ a = a + b; return a; }
inline double to_double(const struct timeval &a)
{ return a.tv_sec + a.tv_usec*1e-6; }
inline int to_usec(const struct timeval &a)
{ return a.tv_sec*USPS + a.tv_usec; }

#endif /* _SYSUTIL_H_ */
