/* this file defines macros and functions for porting between Unix and Win32 */
#ifndef _SYSDEP_H_
#define _SYSDEP_H_

#include <stdio.h>

#ifndef USPS
#define USPS  1000000
#endif

/* To make life easier, we have to make Unix take on some Win32 API,
 * plus, we'll add a few functions for both OS. - Wenyu */
#ifdef __unix
/* on FreeBSD, need to include this before pthread.h to get u_short, etc. */
#if ( defined(_POSIX_C_SOURCE) && !defined(__linux__) )
typedef unsigned short u_short;
typedef unsigned short ushort;
typedef unsigned long u_long;
typedef unsigned int uint;
typedef unsigned int u_int;
typedef unsigned char u_char;
struct timeval { unsigned long tv_sec; unsigned long tv_usec; };

typedef int  socklen_t;

#endif
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/select.h>
#include <errno.h>
#include <string.h>
#include <pthread.h>

/* macros */
#define closesocket close
// use the following inline function instead if you want debugging info
//inline int closesocket(int sd) { printf("closeso(%d)\n", sd); return close(sd); }

/* functions */
inline int get_errno() { return errno; }
inline char *get_errstring() { return strerror(errno); }
inline int readsocket(int sock, char *buf, int n)
{ return read(sock, buf, n); }
inline int writesocket(int sock, const char *buf, int n)
{ return write(sock, buf, n); }

#else ifdef WIN32

//#include <io.h>
#include <winsock2.h>
#include <windows.h> /* CreateThread, ExitThread */
#include "getopt.h"

/* macros */
#define read _read
#define write _write
/* on Unix, socklen_t is unsigned int */
typedef int  socklen_t;
typedef LARGE_INTEGER  HiResTimer_t;
/* we will implement a small subset of pthread API */
typedef unsigned long  pthread_t; // Win32 likes long than int for this
typedef int  pthread_attr_t; /* dummy definition, don't use actual value */
// special case for Win32 API
typedef LPTHREAD_START_ROUTINE pthread_func;
/* functions */
inline int get_errno() { return WSAGetLastError(); }
inline char *get_errstring() { return "Windows Error"; }
inline void perror(const char *s)
{ fprintf(stderr, "%s WinSock Error %d\n", get_errno()); }

inline int readsocket(int sock, char *buf, int n)
{ return recv(sock, buf, n, 0); }
inline int writesocket(int sock, const char *buf, int n)
{ return send(sock, buf, n, 0); }
int HiResTimer_init();
void reset_HiResTimer_state();
int gettimeofday(struct timeval *tp, struct timezone *tzp);

/* caller must always use NULL for "attr" */
int pthread_create(pthread_t *thread, pthread_attr_t *attr, pthread_func start_func, void *arg);
/* caller must pass an integer casted as (void *) */
int pthread_detach(pthread_t thread);
void pthread_exit(void *retval);
inline pthread_t pthread_self(void) { return GetCurrentThreadId(); }

#endif /* WIN32 */

void thread_sleep(int ms);

#endif /* _SYSDEP_H_ */
