#include <assert.h>
#include <math.h>
#include "sysdep.h"

#ifdef WIN32
#include <sys/timeb.h>
//#include <process.h>
//#include <stddef.h>

HiResTimer_t Freq;
double Period;
struct timeval InitialTime;
HiResTimer_t InitialCounter;


int HiResTimer_init()
{
  WSADATA wsa_data;
  if (WSAStartup(2, &wsa_data) != 0) {
	printf("can't initialize winsock 2.0 dll\n");
	return -1;
  }
  if (QueryPerformanceFrequency(&Freq) == 0) {
    printf("this machine doesn't support high resolution timer!\n");
    return -1;
  }
  printf("high resolution timer supported, frequency = (%d,%u)\n",
	 Freq.HighPart, Freq.LowPart);
  Period = 1.0/(double)Freq.QuadPart;
  reset_HiResTimer_state();
  return 0;
}

void reset_HiResTimer_state()
{
  struct _timeb tb;
  _ftime(&tb);
  InitialTime.tv_sec = tb.time;
  InitialTime.tv_usec = tb.millitm*1000;
  QueryPerformanceCounter(&InitialCounter);
}

int gettimeofday(struct timeval *tp, struct timezone *tzp)
{
  HiResTimer_t now;
  double offset; /* elapsed seconds since HiResTimer_init() */
  long off_int;
  QueryPerformanceCounter(&now);
  offset = (now.QuadPart-InitialCounter.QuadPart)*Period;
  if (offset < 0) {
	  printf("HiResolution timer overflowed %d!\n", offset);
	  printf("Resetting the HiResolution timer\n");
	  reset_HiResTimer_state();
	  offset = 0.0;
  }
  off_int = (long)floor(offset); // avoid overflow after 2147.4 sec
  offset -= (double)off_int;
  tp->tv_usec = InitialTime.tv_usec + (long)(offset*USPS);
  /* carry seconds during add operation */
  tp->tv_sec = InitialTime.tv_sec + off_int + tp->tv_usec/USPS;
  tp->tv_usec = tp->tv_usec%USPS;
  return 0;
}

int pthread_create(pthread_t *thread, pthread_attr_t *attr, pthread_func start_func, void *arg)
{
  HANDLE hThread;
  assert(attr == NULL);
  /* allocates 16KB of stack space; thread id happens to be 32-bit 
   * creation flag of 0 runs the child thread immediately. */
  hThread = CreateThread(NULL, 16384, start_func, arg, 0, thread);
  *thread = (pthread_t) hThread;
  if (hThread == NULL)
    return -1;
  else
    return 0;
}

int pthread_detach(pthread_t thread)
{
  int rc = CloseHandle((HANDLE) thread); // it this ok if thread is still running?
  if (rc == 0) // failed
	return -1;
  else // success
	return 0;
}

void pthread_exit(void *retval)
{
  ExitThread((DWORD)retval);
}

#endif


void thread_sleep(int ms)
{
#ifdef __unix
  struct timeval t;
  t.tv_sec = ms/1000; t.tv_usec = (ms%1000)*1000;
  select(0, NULL, NULL, NULL, &t);
#else ifdef WIN32
  Sleep(ms);
#endif
}
