#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "sysutil.h"


void *new_client_handler(void *arg)
{
  static int status = 0;
  printf(" => entering new thread id %d\n", pthread_self());
  sleep(3);
  int sd = *(int *)arg;
  write(sd, "slept\n", 7);
  printf("slept\n");
  close(sd);
  pthread_exit((void *)1);
  return NULL;
}

int main(int argc, char *argv[])
{
  int port = 4367, seedsock, new_sock, rc;
  if (argc > 2) exit(1);
  if (argc == 2)
    port = atoi(argv[1]);

  seedsock = new_server_sock(SOCK_STREAM, port);
  if (seedsock < 0) {
    printf("err socket create\n");
    exit(1);
  }

  socklen_t addrlen;
  struct sockaddr_in mon_addr;
  while(1) {
    addrlen = sizeof(struct sockaddr);
    new_sock = accept(seedsock, (struct sockaddr *) &mon_addr, &addrlen);
    if(new_sock < 0) {
      perror("Error in accepting connection:");
      exit(1);
    }
    printf("accepted new connection from %s\n", inet_ntoa(mon_addr.sin_addr));
    fflush(stdout);

    pthread_t thr_id;
    rc = pthread_create(&thr_id, NULL, new_client_handler, &new_sock);
    if (rc != 0) {
      perror(" **thread creation failed! %s");
      close(new_sock);
    }

  }

  return 0;
}

