/*
* Generate a random 32-bit quantity.
*/
//
#include <string.h>         /* strncpy() */
#include <stdlib.h>         /* atoi() */
#include <stdio.h>          /* printf() */
#ifdef __unix
#include <sys/time.h>       /* gettimeofday() */
#include <unistd.h>         /* get..() */
#include <sys/utsname.h>    /* uname() */
#else ifdef WIN32
#include <process.h>
#define getpid _getpid
#include <sys/types.h>
#include <sys/timeb.h>
#include <winsock2.h>
#endif
//#include "sysdep.h"  can't do it because it's C, not C++
#include <time.h>           /* clock() */
#include "global.h"         /* from RFC 1321 */
#include "md5.h"            /* from RFC 1321 */

extern long gethostid(void);

static char rcsid[] = "$Id: random32.c,v 1.3 1999/01/31 15:27:09 xiaotaow Exp $";

#define MD_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final
typedef unsigned long  u_int32;

static u_int32 md_32(char *string, int length)
{
  MD_CTX context;
  union {
    char   c[16];
    u_int32 x[4];
  } digest;
  u_int32 r;
  int i;
  
  MDInit (&context);
  MDUpdate (&context, (unsigned char *)string, length);
  MDFinal ((unsigned char *)&digest, &context);
  /* XOR the four parts into one word */
  for (i = 0, r = 0; i < 3; i++) r ^= digest.x[i];
  return r;
} /* md_32 */



/*
* Return random unsigned 32-bit quantity.
*/
u_int32 random32(int type)
{
  struct {
    int     type;
    struct  timeval tv;
    clock_t cpu;
#ifdef __unix
    pid_t   pid;
    u_long  hid;
    uid_t   uid;
    gid_t   gid;
    struct  utsname name;
#else ifdef WIN32
	int     pid;
	char    name[32];
#endif
  } s;

#ifdef __unix
  gettimeofday(&s.tv, 0);
#else ifdef WIN32
  struct _timeb tb;
  _ftime(&tb);
  s.tv.tv_sec = tb.time;
  s.tv.tv_usec = tb.millitm*1000;
#endif
  s.type = type;
  s.cpu  = clock();
  s.pid  = getpid();
#ifdef __unix
  s.hid  = gethostid(); // not implemented on win32
  s.uid  = getuid(); //
  s.gid  = getgid(); //
  uname(&s.name);
#else ifdef WIN32
  strcpy(s.name, "Windows 9x/NT");
#endif

  return md_32((char *)&s, sizeof(s));
} /* random32 */
