#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#ifdef __unix
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif
#include "TestSetup.h"
#include "sysutil.h"
#include "hmac_md5.h"
#define MODULE_VERSION "1.3beta"

const u_short cntrl_port = CONTROL_PORT;

char global_keyfile[128];

#ifdef __unix
void *new_client_handler(void *arg)
#else ifdef WIN32
DWORD WINAPI new_client_handler(void *arg)
#endif
{
  static int status = 0;
  printf(" => entering new thread id %d\n", pthread_self());
  TestSetup *tSetup = (TestSetup *) arg;
  tSetup->service();
  delete tSetup;
  fflush(stdout);
#ifdef WIN32
  return (DWORD) &status;
#else ifdef __unix
  return &status;
#endif
  //return NULL;
}

int main(int argc, char *argv[])
{
  int scntrl, new_sock, rc;
  socklen_t addrlen;
  struct sockaddr_in mon_addr;
  char ch;

#ifdef WIN32
  /* this is mostly for imitating gettimeofday() */
  if (HiResTimer_init() < 0) {
	printf("Initialization failed! quiting.\n");
	exit(1);
  }
  HANDLE proc = GetCurrentProcess();
  printf("raising priority to %d for current process, handle=%d\n",
	     HIGH_PRIORITY_CLASS, proc);
  if (SetPriorityClass(proc, HIGH_PRIORITY_CLASS) == 0)
	printf("can't increase process priority, err %d\n", GetLastError());
#endif
  printf("main thread id %d\n", pthread_self());

  printf("module_mt version %s\n", MODULE_VERSION);

  strcpy(global_keyfile, HMAC_KEYFILE); // default
  while ( (ch = getopt(argc, argv, "hf:")) != EOF )
    switch (ch)
      {
      case 'f':
        strncpy(global_keyfile, optarg, 127);
        global_keyfile[127] = '\0';
        break;
      case 'h':
      case '?':
        printf("usage: %s [-f hmac_keyfile=\"%s\"]\n", argv[0], HMAC_KEYFILE);
        exit(1);
      }

  HMAC_auth_central::init(global_keyfile); // read shared secret key

  /* bind to socket for commands */
  scntrl = new_server_sock(SOCK_STREAM, cntrl_port);
  if (scntrl < 0) {
    printf("Control: %s", sysutil_errstr);
    exit(1);
  }//else
  // printf("control sock = %d\n", scntrl);

  while(1) {

    addrlen = sizeof(struct sockaddr_in);
    memset(&mon_addr, 0, addrlen);
    fflush(stdout);
    new_sock = accept(scntrl, (struct sockaddr *) &mon_addr, &addrlen);
    if(new_sock < 0) {
      perror("Error in accepting connection:");
      exit(1);
    }
    printf("accepted new connection %d from %s\n", new_sock, 
           inet_ntoa(mon_addr.sin_addr));
    TestSetup *tSetup = new TestSetup(new_sock);
    // we should reset it if there is no active test now.
    //reset_HiResTimer_state(); // reset it for every test

    pthread_t thr_id;
    rc = pthread_create(&thr_id, NULL, new_client_handler, tSetup);
    if (rc != 0) {
      printf(" **thread creation failed! %s\n", get_errstring());
      closesocket(tSetup->csock);
    }else {
#ifdef WIN32
	  printf("increasing priority to %d for thread handle %d\n",
			 THREAD_PRIORITY_ABOVE_NORMAL, thr_id);
	  if (SetThreadPriority((HANDLE)thr_id, THREAD_PRIORITY_ABOVE_NORMAL) == 0)
		printf("failed to increase thread priority, err %d\n", GetLastError());
#endif

      rc = pthread_detach(thr_id);
      if (rc != 0)
        printf("pthread_detach() failed! %s\n", get_errstring());
    }

  } // end of while

  return 0;
}

