/*
md5-util.c - adds a convenience function for MD5 encoding.

Copyright 1998, 1999, 2000 by Columbia University; all rights reserved.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h> /* strlen */
#include "md5.h"

/*
 * MD5String()
 * Used to generate digest string (32 ASCII printable characters, plus
 * terminating nul) from 16 unsigned digest characters.
 */
static char *MD5String(unsigned char digest[16]) {
  unsigned int i;
  char *digestStr;
 
  digestStr = (char *)malloc(33*sizeof(char));
 
  for (i=0; i<16; i++)
    sprintf(&digestStr[2*i], "%02x", digest[i]);
 
  digestStr[32] = 0;
  return digestStr;
} /* MD5String */


/*
 * MD5()
 * Used to generate MD5 string.
 */
char *MD5(char *str)
{
  MD5_CTX context;
  unsigned char digest[16];
  unsigned int len = strlen (str);
 
  MD5Init (&context);
  MD5Update (&context, (unsigned char *)str, len);
  MD5Final (digest, &context);
 
  return (MD5String(digest));
} /* MD5 */
