#ifndef _HMAC_MD5_H_
#define _HMAC_MD5_H_
#include "sysdep.h"

#ifdef  __cplusplus
extern "C" {
#endif
typedef unsigned int u_int32;
extern u_int32 random32(int type);

#ifdef  __cplusplus
}
#endif

void hmac_md5(unsigned char *text, int text_len,
              unsigned char *key, int key_len,
              unsigned char *hmac_result);


void md5_simple(unsigned char *text, int text_len, unsigned char *digest);

void hmac_read_key(char *keyfile, unsigned char *key, int *key_len);

#define CONtroller 0x1
#define ENDpoint 0x2

class HMAC_auth {
  int mlen_net; // total message length
  unsigned char auth_data[16]; // the HMAC-MD5 digest
  unsigned char replay_prv_net[4]; // a 32-bit increasing replay_prevention counter, network order
  unsigned long nonce_net;
  //unsigned char dest_ip[4]; // destination (recipient) IP, in big-endian

  unsigned char internal_buf[1024]; // putting together for HMAC computation
  int sock; // socket associated with destination (recipient of auth-data)
  int my_type;

  unsigned long replay_prv_cnt;
  unsigned long nonce_val; // same nonce value per connection
  unsigned char shared_secret[16];
  int secret_len;

public:
  // Constructor; prog_type is 0x1 for controller, 0x2 for endpoint.
  HMAC_auth(int sd, int prog_type, char *keyfile);

  // req - pointer to the text to be authenticated
  // req_len - length in bytes
  void send_req(unsigned char *req, int req_len);
  // returns true if authentication succeeds, false otherwise, 
  // returns 2 if connection closed
  int receive_req(unsigned char *req, int *req_len);

  unsigned long get_nonce() { return nonce_val; }

private:
  void calc_digest(unsigned char *req, int req_len);
};


#define HMAC_KEYFILE "hmac_key.txt"  // default
//#define REPLAY_COUNTER_FILE "replay_prevent.counter"

class HMAC_auth_central {
  // shared secret key for HMAC-MD5 authentication
  static unsigned char shared_secret[16];
  static int secret_len;
public:
  static void init(char *keyfile); // read from a counter file, and key file

  static unsigned char *get_key() { return shared_secret; }
  static int get_keylen() { return secret_len; }
};

#define SENDER_mode 0x1
#define RECEIVER_mode 0x2

struct start_request {
  int mode; // sender or receiver
  u_long sender_ip;
  u_long receiver_ip;
  u_short data_port;
  u_short numways; // 1-way or 2-way
  int runtime; // duration
  int pktgap; // packet gap in microsec
  int pktsize; // packet size in bytes
  int alive_gap; // 0 to disable keep-alive, otherwise measured in seconds
  char filename[64]; // support file names up to 64-char long
};


struct file_request {
  u_short file_port;
  char filename[64]; // support file names up to 64-char long
};

#define StartTEST 0x1
#define GetFILE 0x2
#define CHALLENGE 0x3

struct test_request {
  int req_cmd; // StartTEST (0x1) or GetFILE (0x2), or CHALLENGE (0x3)
  union {
    struct start_request start;
    struct file_request file;
    int nonce_val; // case 0x3
  } un;
};

#endif /* _HMAC_MD5_H_ */
