#ifndef _TESTSETUP_H_
#define _TESTSETUP_H_

#ifdef __unix
#include <sys/time.h>
#include <netinet/in.h>
#else ifdef WIN32
#include <winsock2.h>
#endif

#include "sysdep.h"
#include "udpexpt.h"
#include "hmac_md5.h"
#include <stdio.h>

#define CONTROL_PORT    4367             /* Default control port */
#define DATA_PORT       4368             /* Default send port */
#define FILE_PORT       4369             /* Default file port */
#define PKTSIZE		36		/* default packet size */
#define PKTGAP          30000
#define RUNTIME         10800
#define NPKT		1000		/* default number of packets */
#define MAXHNAME	100		/* maximum hostname size */
//#define NARGS           5               /* max num. args. in control msg */
#define ALIVE_GAP       60
//#define NO              0
//#define YES             1

#define TRANSPORT_UDP   0
#define TRANSPORT_TCP   1
#define TRANSPORT_BOTH  2

/* each thread serving a new connection (a UDP trace test) has one below. */
class TestSetup
{
public:
  int csock; // control message socket (TCP)
  int data_sock; // data/test stream socket (UDP)
#ifdef WIN32
  int dummy_sock; // Winsock doesn't allow select with all NULL fdset
#endif

  // test parameters specified by controller
  u_long sender_ip;
  u_long receiver_ip;
  bool is_sender; // if not sender, then must be receiver
  u_short data_port;
  u_short file_port;
  //int gbl_transport; always use UDP
  struct timeval pktgap;
  int pktsize;
  int numways;
  int runtime;
  bool keepalives;
  int alive_gap; // in seconds
  char log_filename[255]; // trace file

  // derived and internal variables used in a test
  bool is_sending;
  int n_sentpackets;
  int n_receivepackets;
  struct timeval donetime;
  struct timeval next_sendtime;
  struct timeval next_alivetime;
  FILE *log_file;
  int test_init;
  double initsecs;

  bool finished;
  bool retrieved;

  HMAC_auth auth_hdr;
  u_int32 nonce; // nonce value for challenge-response. same per connection

public:
  TestSetup(int new_sock);

  void service();

protected:
  void EmitPacket(bool stop, char *);
  int SendPacket(char *data, int maxlen, struct sockaddr_in *to);
  int GetPacket(char *data, int maxlen, struct sockaddr_in *from);

  int TestSetup::start_test(struct start_request &params);
  int ProcessControl();
  int ProcessArrival( char data[]);
  int ProcessReflection(char data[]);

  int InitializeSender();
  int InitializeReceiver();
  int InitRetriever(char *ext);

  int OpenLog();
  void WriteLog(struct udprecord *rec);

  void cleanup_thread(int rc);

  unsigned long get_nonce() { return auth_hdr.get_nonce(); }
  int max_sd(); // find the max sock descriptor for purpose of select()
  // tells when an agent is responsible for logging the trace file
  bool is_logger() { return is_sender ? (numways == 2) : (numways == 1); }
};

void cleanup_socket(int &sock);
inline bool is_ready(int sock, fd_set *fdset)
{ return sock>=0 && FD_ISSET(sock, fdset); }

#endif
