/*
 * kGuard Copyright (C) 2010 Columbia University
 *
 * This software was developed by Vasileios P. Kemerlis <vpk@cs.columbia.edu>
 * at Columbia University, New York, NY, USA, in November 2010.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __KGUARD_H__
#define __KGUARD_H__

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "target.h"
#include "basic-block.h"
#include "rtl.h"
#include "gcc-plugin.h"
#include "tree-flow.h"
#include "tree-pass.h"
#include "hashtab.h"
#include "config/i386/i386-protos.h"

/* plugin name and version */
#define NAME		"kGuard"
#define VER		"3.14alpha"

/* constants */
#define BASE10 		10	/* 10th base */
#define VER_DELIM	'.'	/* version delimiter */
#define HTAB_SZ_DFL	16	/* default hash table size */
#define STUB_STR	"stub"	/* stub option (argument) literal */
#define RETPROT_STR	"retprot"	/* retprot option (argument) literal */
#define RETPROT_DFL	0	/* retprot default value */
#define NOP_STR		"nop"	/* nop option (argument) literal */
#define NOP_DFL		16		/* nop default value */

#ifdef DEBUG
#define LOG_STR		"log"	/* log option (argument) literal */
#endif

#if	linux && __amd64__
#define KADDR_DFL	0x0		/* kaddr default value */
#define STUB_DFL	"panic"		/* stub default value */
#define BP_NUM		6	/* number of the BP register (hard register) */
#define S_REG		5	/* number of the register to be spilled
				   (hard register) */
#elif	linux && __i386__
#define KADDR_DFL	0xC0000000	/* kaddr default value */
#define STUB_DFL	"panic"		/* stub default value */
#define BP_NUM		6	/* number of the BP register (hard register) */
#define S_REG		5	/* number of the register to be spilled
				   (hard register) */
#else
#error	"[!] Unsupported platform"	/* unknown platform */
#endif

/* differentiate based on the machine's ISA (32- vs 64-bit) */
#if __SIZEOF_POINTER__ == 8
#define MMODE		DImode	/* double integer; 8-bytes */
#else
#define MMODE		SImode	/* single integer; 4-bytes */
#endif	/* MMODE */

/* compiler directives for branch prediction */
#define likely(x) 	__builtin_expect((x), 1)
#define unlikely(x)	__builtin_expect((x), 0)

enum {
	SUCC = 0,	/* success; return value */
	FAIL = 1	/* failed; return value */
};

enum {
	UNSAFE_INSTR	= 0,	/* constant; indicates the instrumentation of
				   an unsafe instruction */
	SAFE_M_INSTR	= 1,	/* constant; indicates the instrumentation of 
				   a safe instruction (memory) */
	SAFE_R_INSTR	= 2,	/* constant; indicates the instrumentation of 
				   a safe instruction (register) */
	SAFE_RET_INSTR	= 3,	/* constant; indicates the instrumentation of
				   a safe return instruction (memory) */
	NO_INSTR	= 4	/* constant; indicates that a branching	
				   instruction is not instrumented */
};

#endif /* __KGUARD_H__ */
