function [R A eigvals Cxx] = PCA_SAMPLE(X, m)
%________________________________________________________
% INPUTS:
%   o X = (x^1...x^n) (n x d) is a set of n samples of 
%     random variable X=(X_1...X_d)
%   o m < d is an integer
% OUTPUTS:
%   o R = (R^1...R^n) (n x m) is a set of n samples of 
%     the PCA representation of X
%   o A (d x m) is a PCA transformation R^d -> R^m  
%   o eigvals is the m largest eigenvalues of Cxx
%________________________________________________________
[n d] = size(X);
M = zeros(n,d);
for dim = 1:d
    M(:,dim) = sum(X(:,dim)) / n;
end
tildeX = X - M;
Cxx = tildeX' * tildeX; % scaling by 1/n doesn't matter
[A eigvals] = PCA_PROJECTION(Cxx,m);
R = X * A;
