function [A eigvals] = PCA_PROJECTION(Cxx, m)
%________________________________________________________
% INPUTS:
%   o Cxx is a covariance matrix for random variable 
%     X=(X_1...X_d) with E[X_j]=0
%   o m < d is an integer
% OUTPUTS:
%   o A (d x m) is a PCA transformation R^d -> R^m  
%   o eigvals is the m largest eigenvalues of Cxx
%________________________________________________________
[Qr Lr] = eig(Cxx);
Q = fliplr(Qr);
A = Q(:,1:m);
eigvals = fliplr(diag(Lr)')';