function [S T A B singvals Omega] = CCA_SAMPLE(X, Y, m)
%________________________________________________________
% INPUTS:
%   o X = (x^1...x^n) (n x d) is a set of n samples of 
%     random variable X=(X_1...X_d)
%   o Y = (y^1...y^n) (n x d') is a set of n samples of 
%     random variable Y=(Y_1...Y_dp)
%   o m < min(d,dp) is an integer
% OUTPUTS:
%   o S = (S^1...S^n) (n x m) is a set of n samples of 
%     the CCA representation of X
%   o T = (T^1...T^n) (n x m) is a set of n samples of 
%     the CCA representation of Y
%   o A (d x m) is a CCA projection R^d -> R^m  
%   o B (dp x m) is a CCA projection R^dp -> R^m  
%   o singvals is the m largest eigenvalues of Omega
%________________________________________________________
tol = 1e-5;
[n d] = size(X);
dp = size(Y,2);
Mx = zeros(n,d);
My = zeros(n,dp);
for dim = 1:d
    Mx(:,dim) = sum(X(:,dim)) / n;
end
for dim = 1:dp
    My(:,dim) = sum(Y(:,dim)) / n;
end
tildeX = X - Mx;
tildeY = Y - My;

r = rank(tildeX' * tildeX, tol); 
rp = rank(tildeY' * tildeY, tol);
barX = PCA_SAMPLE(tildeX, r);
barY = PCA_SAMPLE(tildeY, rp); % preprocess with PCA

Cxy = barX' * barY;
Cxx = barX' * barX; 
Cyy = barY' * barY; % scaling by 1/n cancels
[A B singvals Omega] = CCA_PROJECTION(Cxy,Cxx,Cyy,m);

S = X * A;
T = Y * B; 