function [A B singvals Omega] = CCA_PROJECTION(Cxy, Cxx, Cyy, m)
%________________________________________________________
% INPUTS:
%   o Cxy, Cxx, and Cyy are covariance matrices for 
%     random variables X=(X_1...X_d) and Y=(Y_1...Y_dp)
%     with E[X_j]=0 and E[Y_j]=0
%   o m < min(d,dp) is an integer
% OUTPUTS:
%   o A (d x m) and B (dp x m) are the CCA projections
%   o singvals is the m largest singular values of Omega
%________________________________________________________
Omega = sqrtm(Cxx) \ Cxy / sqrtm(Cyy);
[Um Sm Vm] = svds(Omega,m);
A = sqrtm(Cxx) \ Um;
B = sqrtm(Cyy) \ Vm;
singvals = diag(Sm);