/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import datastructures.UserParameters;
import edu.rit.numeric.Statistics;
import java.math.BigDecimal;
import statistics.AbstractStatisticTests;
import statistics.IStatisticalTest;

public class Phi_Contrasts
extends AbstractStatisticTests
implements IStatisticalTest {
    static BigDecimal[] lnFactorialList = new BigDecimal[5000];

    static {
        Phi_Contrasts.lnFactorialList[0] = new BigDecimal("0");
        int i = 1;
        while (i < 5000) {
            BigDecimal number = new BigDecimal(Math.log(i));
            Phi_Contrasts.lnFactorialList[i] = lnFactorialList[i - 1].add(number);
            ++i;
        }
    }

    public Phi_Contrasts(UserParameters userParams) {
        super(userParams);
    }

    @Override
    public double TestCasesOnly(int order, int[][] observedCases) {
        double z_cases = this.TestCasesOnly_Zscore(order, observedCases);
        double probability = Statistics.chiSquarePvalue((double)1.0, (double)Math.pow(z_cases, 2.0));
        return probability;
    }

    @Override
    public double TestCasesVsControls(int order, int[][] observedCases, int[][] observedControls) {
        double z_diff = this.TestCasesVsControls_Zscore(order, observedCases, observedControls);
        double probability = Statistics.chiSquarePvalue((double)1.0, (double)Math.pow(z_diff, 2.0));
        return probability;
    }

    @Override
    public double TestCasesOnly_Zscore(int order, int[][] observedCases) {
        double phi_coeff = observedCases[1][1] * observedCases[0][0] - observedCases[1][0] * observedCases[0][1];
        double std_dev = Math.sqrt((double)(observedCases[1][1] + observedCases[1][0]) * (double)(observedCases[1][1] + observedCases[0][1]) * (double)(observedCases[0][0] + observedCases[0][1]) * (double)(observedCases[0][0] + observedCases[1][0]) / (double)this.totalCases);
        double z_cases = phi_coeff / std_dev;
        return z_cases;
    }

    @Override
    public double TestCasesVsControls_Zscore(int order, int[][] observedCases, int[][] observedControls) {
        double phi_coeff_cases = observedCases[1][1] * observedCases[0][0] - observedCases[1][0] * observedCases[0][1];
        double var_cases = (double)(observedCases[1][1] + observedCases[1][0]) * (double)(observedCases[1][1] + observedCases[0][1]) * (double)(observedCases[0][0] + observedCases[0][1]) * (double)(observedCases[0][0] + observedCases[1][0]) / (double)this.totalCases;
        double phi_coeff_controls = observedControls[1][1] * observedControls[0][0] - observedControls[1][0] * observedControls[0][1];
        double var_controls = (double)(observedControls[1][1] + observedControls[1][0]) * (double)(observedControls[1][1] + observedControls[0][1]) * (double)(observedControls[0][0] + observedControls[0][1]) * (double)(observedControls[0][0] + observedControls[1][0]) / (double)this.totalControls;
        double z_contrast = (phi_coeff_cases - phi_coeff_controls) / Math.sqrt(var_cases + var_controls);
        return z_contrast;
    }
}

