/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import datastructures.UserParameters;
import edu.rit.numeric.Statistics;
import java.math.BigDecimal;
import statistics.AbstractStatisticTests;
import statistics.IStatisticalTest;

public class D_Contrasts
extends AbstractStatisticTests
implements IStatisticalTest {
    static BigDecimal[] lnFactorialList = new BigDecimal[5000];

    static {
        D_Contrasts.lnFactorialList[0] = new BigDecimal("0");
        int i = 1;
        while (i < 5000) {
            BigDecimal number = new BigDecimal(Math.log(i));
            D_Contrasts.lnFactorialList[i] = lnFactorialList[i - 1].add(number);
            ++i;
        }
    }

    public D_Contrasts(UserParameters userParams) {
        super(userParams);
    }

    public double TestRareCombinations(int order, double lambda, int observed) {
        double poisson_p = 0.0;
        int k = observed;
        while (k <= observed + 10) {
            BigDecimal numerator = new BigDecimal(-lambda + (double)k * Math.log(lambda));
            double log_poisson_p = numerator.subtract(lnFactorialList[k]).doubleValue();
            poisson_p += Math.exp(log_poisson_p);
            ++k;
        }
        return poisson_p;
    }

    @Override
    public double TestCasesOnly(int order, int[][] observedCases) {
        double z_cases = this.TestCasesOnly_Zscore(order, observedCases);
        double probability = Statistics.chiSquarePvalue((double)1.0, (double)Math.pow(z_cases, 2.0));
        return probability;
    }

    @Override
    public double TestCasesVsControls(int order, int[][] observedCases, int[][] observedControls) {
        double z_diff = this.TestCasesVsControls_Zscore(order, observedCases, observedControls);
        double probability = Statistics.chiSquarePvalue((double)1.0, (double)Math.pow(z_diff, 2.0));
        return probability;
    }

    @Override
    public double TestCasesOnly_Zscore(int order, int[][] observedCases) {
        double P = (double)(observedCases[1][1] + observedCases[1][0]) / (double)this.totalCases;
        double Q = (double)(observedCases[1][1] + observedCases[0][1]) / (double)this.totalCases;
        double expectedCoCarriers = P * Q * (double)this.totalCases;
        double D_cases = ((double)observedCases[1][1] - expectedCoCarriers) / (double)this.totalCases;
        double sigma_cases = Math.sqrt(P * (1.0 - P) * Q * (1.0 - Q) / (double)this.totalCases);
        double z_cases = D_cases / sigma_cases;
        return z_cases;
    }

    @Override
    public double TestCasesVsControls_Zscore(int order, int[][] observedCases, int[][] observedControls) {
        double MIN_CASE_FREQ = 1.0 / (double)(this.totalCases + 1);
        double MIN_CONTROL_FREQ = 1.0 / (double)(this.totalControls + 1);
        double P = (double)(observedCases[1][1] + observedCases[1][0]) / (double)this.totalCases;
        double Q = (double)(observedCases[1][1] + observedCases[0][1]) / (double)this.totalCases;
        P = Math.max(P, MIN_CASE_FREQ);
        Q = Math.max(Q, MIN_CASE_FREQ);
        double expectedCaseCarriers = P * Q * (double)this.totalCases;
        double D_cases = ((double)observedCases[1][1] - expectedCaseCarriers) / (double)this.totalCases;
        double sigma_cases = Math.sqrt(P * (1.0 - P) * Q * (1.0 - Q) / (double)this.totalCases);
        double p = (double)(observedControls[1][1] + observedControls[1][0]) / (double)this.totalControls;
        double q = (double)(observedControls[1][1] + observedControls[0][1]) / (double)this.totalControls;
        p = Math.max(p, MIN_CONTROL_FREQ);
        q = Math.max(q, MIN_CONTROL_FREQ);
        double expectedControlCarriers = p * q * (double)this.totalControls;
        double D_controls = ((double)observedControls[1][1] - expectedControlCarriers) / (double)this.totalControls;
        double sigma_controls = Math.sqrt(p * (1.0 - p) * q * (1.0 - q) / (double)this.totalControls);
        double D_diff = D_cases - D_controls;
        double sigma_diff = Math.sqrt(Math.pow(sigma_cases, 2.0) + Math.pow(sigma_controls, 2.0));
        double z_diff = D_diff / sigma_diff;
        return z_diff;
    }
}

