/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import datastructures.WorkUnit;
import gridmath.CaseMatrixBase;
import gridmath.NumberOfCombinations;
import java.util.Vector;
import pac.SearchDatastructure;

public class ParameterOptimizer {
    private SearchDatastructure searcher;
    private int sample_increment;
    private final int min_k = 1;
    private final int max_k = 40;
    private double[][] windowBoundaries;

    public ParameterOptimizer(SearchDatastructure I) {
        this.searcher = I;
        this.sample_increment = 1;
        this.windowBoundaries = this.searcher.windowMaker.getWindowBoundaries();
    }

    public Vector<WorkUnit> optimallyDistributeWork(CaseMatrixBase pSignificantMatrix, CaseMatrixBase pLEMatrix, NumberOfCombinations exhaustiveCombinations) {
        Vector<WorkUnit> distributedWork = new Vector<WorkUnit>();
        System.out.println("|----------------------------------------------------------------------| 100%");
        System.out.print(" ");
        int i = 0;
        while (i < this.searcher.windowMaker.getNoOfWindows()) {
            System.out.print(".");
            int j = i;
            while (j < this.searcher.windowMaker.getNoOfWindows()) {
                double[] maxFreqs = new double[]{this.windowBoundaries[i][1], this.windowBoundaries[j][1]};
                int[] numberOfVariables = new int[]{this.searcher.windowMaker.counter[i], this.searcher.windowMaker.counter[j]};
                WorkUnit optimalWorkUnit2D = this.findOptimalSearchParameters(pSignificantMatrix.getMatrix2D()[i][j], pLEMatrix.getMatrix2D()[i][j], maxFreqs, numberOfVariables, (long)exhaustiveCombinations.getMatrix2D()[i][j], new int[]{i, j});
                if (optimalWorkUnit2D != null) {
                    distributedWork.add(optimalWorkUnit2D);
                }
                ++j;
            }
            ++i;
        }
        return distributedWork;
    }

    public double getCandidatesPerSampleIncrement(int k, int trial_increments, double[] maxFrequencies, int[] numberOfVariables) {
        double vars_from_window1 = (double)numberOfVariables[0] * Math.pow(maxFrequencies[0], k);
        double vars_from_window2 = (double)numberOfVariables[1] * Math.pow(maxFrequencies[1], k);
        double candidates_per_trial_increment = (double)trial_increments * vars_from_window1 * vars_from_window2;
        return candidates_per_trial_increment;
    }

    public WorkUnit findOptimalSearchParameters(double pSignificance, double pNull, double[] maxFrequencies, int[] numberOfVariables, long exhaustiveCombinations, int[] coordinates) {
        if (pSignificance == 0.0 || pNull == 0.0) {
            return null;
        }
        int var = 0;
        while (var < maxFrequencies.length) {
            if (maxFrequencies[var] == 0.0 || numberOfVariables[var] == 0) {
                return null;
            }
            ++var;
        }
        double total_power = 0.0;
        double worstCaseCombinations = 0.0;
        int[] samples_per_k = new int[40];
        double[] power_per_k = new double[40];
        double required_power = this.searcher.userParams.getPower();
        while (total_power < required_power) {
            int best_k = -1;
            double best_power = 0.0;
            double best_candidates = 0.0;
            double best_sample_increment = 0.0;
            double best_bang_per_buck = 0.0;
            int this_k = 1;
            while (this_k < 40) {
                this.sample_increment = 1;
                double power_increment_k = 1.0 - Math.pow(1.0 - Math.pow(pSignificance, this_k), samples_per_k[this_k] + this.sample_increment) - power_per_k[this_k];
                if (!(power_increment_k < 1.0E-8)) {
                    if (power_increment_k < 5.0E-8) {
                        this.sample_increment = 25000;
                    } else if (power_increment_k < 1.0E-7) {
                        this.sample_increment = 5000;
                    } else if (power_increment_k < 5.0E-7) {
                        this.sample_increment = 1000;
                    } else if (power_increment_k < 1.0E-6) {
                        this.sample_increment = 250;
                    } else if (power_increment_k < 5.0E-6) {
                        this.sample_increment = 50;
                    }
                    power_increment_k = 1.0 - Math.pow(1.0 - Math.pow(pSignificance, this_k), samples_per_k[this_k] + this.sample_increment) - power_per_k[this_k];
                    double candidates_per_sample_increment = this.getCandidatesPerSampleIncrement(this_k, this.sample_increment, maxFrequencies, numberOfVariables);
                    double bang_per_buck = power_increment_k / (candidates_per_sample_increment + 0.1 * (double)this.sample_increment);
                    if (bang_per_buck > best_bang_per_buck) {
                        best_k = this_k;
                        best_power = power_increment_k;
                        best_candidates = candidates_per_sample_increment;
                        best_sample_increment = this.sample_increment;
                        best_bang_per_buck = bang_per_buck;
                    }
                }
                ++this_k;
            }
            if (best_power >= (double)this.searcher.userParams.getPower()) {
                int i = 0;
                while (i < samples_per_k.length) {
                    if (i != best_k) {
                        samples_per_k[i] = 0;
                        power_per_k[i] = 0.0;
                        worstCaseCombinations = 0.0;
                        total_power = 0.0;
                    }
                    ++i;
                }
            }
            int n = best_k;
            samples_per_k[n] = (int)((double)samples_per_k[n] + best_sample_increment);
            int n2 = best_k;
            power_per_k[n2] = power_per_k[n2] + best_power;
            worstCaseCombinations += best_candidates;
            total_power += best_power;
        }
        return new WorkUnit(samples_per_k, power_per_k, coordinates, exhaustiveCombinations, worstCaseCombinations);
    }
}

