/*
 * Decompiled with CFR 0.152.
 */
package io;

import datastructures.Interaction;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SxpcFileReader {
    public Interaction[] readProcessedHitsFile(String hitsfileName) throws IOException {
        String entry;
        BufferedReader hitsfile = new BufferedReader(new FileReader(hitsfileName));
        hitsfile.readLine();
        Vector<Interaction> hitsfileContents = new Vector<Interaction>();
        while ((entry = hitsfile.readLine()) != null) {
            hitsfileContents.add(new Interaction(entry));
        }
        Interaction[] interactionList = new Interaction[hitsfileContents.size()];
        int i = 0;
        while (i < hitsfileContents.size()) {
            interactionList[i] = (Interaction)hitsfileContents.elementAt(i);
            ++i;
        }
        hitsfileContents = null;
        return interactionList;
    }

    public Integer[] readHitsIndexFile(String hitsIndexFileName) throws IOException {
        Vector<Integer> hitsIndices = new Vector<Integer>();
        try {
            BufferedReader b = new BufferedReader(new FileReader(hitsIndexFileName));
            String line = null;
            while ((line = b.readLine()) != null) {
                hitsIndices.add(Integer.parseInt(line));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Integer[] hitsIndexArray = new Integer[hitsIndices.size()];
        hitsIndices.toArray(hitsIndexArray);
        return hitsIndexArray;
    }

    public Vector<String[]> readUnprocessedHitsFile(String hitsfileName) throws IOException {
        Vector<String[]> variables = new Vector<String[]>();
        try {
            BufferedReader b = new BufferedReader(new FileReader(hitsfileName));
            String line = null;
            while ((line = b.readLine()) != null) {
                StringTokenizer strTok = new StringTokenizer(line, "\t");
                if (strTok.countTokens() != 0 && strTok.countTokens() % 2 == 0) {
                    boolean alreadyHasPvals = strTok.countTokens() % 2 != 0;
                    int leaveBehindTokens = 0;
                    if (alreadyHasPvals) {
                        leaveBehindTokens = 1;
                    }
                    String[] interaction = new String[strTok.countTokens() - leaveBehindTokens];
                    int entry = 0;
                    while (strTok.countTokens() > leaveBehindTokens) {
                        interaction[entry] = new String(strTok.nextToken());
                        ++entry;
                    }
                    variables.add(interaction);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return variables;
    }
}

