/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import preprocessing.WindowingSystem;

public class SearchAreaCalculator
extends CaseMatrixBase {
    private final double sensitivity;
    private final int strength;
    private final long t;

    public SearchAreaCalculator(UserParameters userparams, WindowingSystem windowmaker, int k, int trials) {
        super(windowmaker, userparams.getMaxorder());
        this.sensitivity = userparams.getPower();
        this.t = trials;
        this.strength = k;
        this.specialTypeOfOperation = MatrixOperations.calculateSearchArea;
        this.specialTypeOfOperand = MatrixOperations.calculateNeededCases;
    }

    @Override
    public double doOperation(double pAtCoordinate) {
        double pk = Math.pow(pAtCoordinate, this.strength);
        double prob = 1.0 - Math.pow(1.0 - pk, this.t);
        return prob > this.sensitivity ? prob : 0.0;
    }

    public long getNumberOfTrials() {
        return this.t;
    }
}

