/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import preprocessing.WindowingSystem;

public class PenetranceCalculator
extends CaseMatrixBase {
    private final int Cases;
    private final double minPenetrance;

    public PenetranceCalculator(UserParameters userparams, WindowingSystem windowmaker) {
        super(windowmaker, userparams.getMaxorder());
        this.Cases = userparams.getNumber_of_cases();
        this.minPenetrance = userparams.getPenetrance();
        this.specialTypeOfOperation = MatrixOperations.calculatePenetrantCases;
        this.specialTypeOfOperand = MatrixOperations.calculateMaxCases;
    }

    @Override
    public double doOperation(double maxCases) {
        return Math.min(Math.floor(maxCases * this.minPenetrance), (double)this.Cases + 1.0);
    }
}

