/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.SNPInfo;
import java.util.Hashtable;
import java.util.Vector;

public class MapfileWrapper {
    private SNPInfo[] snps;
    private Hashtable<String, Integer> snpIndex;

    public MapfileWrapper(SNPInfo[] mapFile) {
        this.snps = mapFile;
        this.snpIndex = new Hashtable();
        int index = 0;
        while (index < mapFile.length) {
            this.snpIndex.put(mapFile[index].getRsid(), index);
            ++index;
        }
    }

    public int getNumberOfSNPs() {
        return this.snps.length;
    }

    public SNPInfo getSNPInfo(int index) {
        if (index < 0 || index >= this.snps.length) {
            return null;
        }
        return this.snps[index];
    }

    public int getSNPIndex(String rsID) {
        return this.snpIndex.get(rsID);
    }

    public int[] interactionToVariables(String[] interaction) {
        int[] variables = new int[interaction.length / 2];
        int i = 0;
        while (i < interaction.length / 2) {
            String mode = interaction[2 * i];
            int modeOffset = mode.compareTo("d") == 0 ? 0 : 1;
            String rsID = interaction[2 * i + 1].replace(" ", "");
            int snpOffset = 2 * this.snpIndex.get(rsID);
            variables[i] = snpOffset + modeOffset;
            ++i;
        }
        return variables;
    }

    public Vector<SNPInfo> getSNPs(int[] variables) {
        boolean[] uniqueVariables = new boolean[this.snps.length];
        int reducedNumberOfSNPs = 0;
        int i = 0;
        while (i < variables.length) {
            int snpNo = (int)Math.floor(variables[i] / 2);
            if (!uniqueVariables[snpNo]) {
                uniqueVariables[snpNo] = true;
                ++reducedNumberOfSNPs;
            }
            ++i;
        }
        Vector<SNPInfo> reducedSNPset = new Vector<SNPInfo>();
        int snp = 0;
        while (snp < uniqueVariables.length) {
            if (uniqueVariables[snp]) {
                reducedSNPset.add(this.snps[snp]);
            }
            ++snp;
        }
        return reducedSNPset;
    }
}

