/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import datastructures.MapfileWrapper;
import datastructures.SNPInfo;
import io.OutputWriter;
import java.io.IOException;
import pac.SearchDatastructure;

public class RandomDraws {
    private SearchDatastructure searcher;
    private OutputWriter outputter;
    private MapfileWrapper snpSet;
    private long numberOfDraws;
    private int drawMode;
    private double pairDistance;

    public RandomDraws(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
        this.snpSet = new MapfileWrapper(this.searcher.snpList);
        this.numberOfDraws = this.searcher.userParams.getNumberOfDraws();
        this.drawMode = this.searcher.userParams.getAllOrTransOrCis();
        this.pairDistance = this.searcher.userParams.getBlockSizeBp();
    }

    public int findAnAppropriateVariableToPairWithThisOne(int variable1) {
        SNPInfo snpinfo1 = this.snpSet.getSNPInfo((int)Math.floor(variable1 / 2));
        int variable2 = (int)Math.floor(Math.random() * (double)(2 * this.snpSet.getNumberOfSNPs()));
        SNPInfo snpinfo2 = this.snpSet.getSNPInfo((int)Math.floor(variable2 / 2));
        if (this.drawMode == 0) {
            while (snpinfo2 == null && (int)Math.floor(variable2 / 2) == (int)Math.floor(variable1 / 2)) {
                variable2 = (int)Math.floor(Math.random() * (double)(2 * this.snpSet.getNumberOfSNPs()));
                snpinfo2 = this.snpSet.getSNPInfo((int)Math.floor(variable2 / 2));
            }
            return variable2;
        }
        if (this.drawMode == 1) {
            while (snpinfo2 == null || snpinfo1.getChromosome() == snpinfo2.getChromosome() && (double)Math.abs(snpinfo1.getBp_distance() - snpinfo2.getBp_distance()) < this.pairDistance) {
                variable2 = (int)Math.floor(Math.random() * (double)(2 * this.snpSet.getNumberOfSNPs()));
                snpinfo2 = this.snpSet.getSNPInfo((int)Math.floor(variable2 / 2));
            }
            return variable2;
        }
        if (this.drawMode == 2) {
            int counter = 0;
            while (snpinfo2 == null || snpinfo1.getChromosome() != snpinfo2.getChromosome() || (double)Math.abs(snpinfo1.getBp_distance() - snpinfo2.getBp_distance()) > this.pairDistance || snpinfo1.getBp_distance() == snpinfo2.getBp_distance()) {
                variable2 = (int)Math.floor(Math.random() * (double)(2 * this.snpSet.getNumberOfSNPs()));
                snpinfo2 = this.snpSet.getSNPInfo((int)Math.floor(variable2 / 2));
                if (++counter <= 100000) continue;
                System.out.println("Skipping.");
                return -1;
            }
            return variable2;
        }
        return variable2;
    }

    public void drawPairs() throws IOException {
        int[] variables = new int[2];
        int draw = 0;
        while ((long)draw < this.numberOfDraws) {
            if ((long)(draw * 100) % this.numberOfDraws == 0L) {
                System.out.println("Finished " + (long)(draw * 100) / this.numberOfDraws + "%");
            }
            variables[0] = (int)Math.floor(Math.random() * (double)(2 * this.snpSet.getNumberOfSNPs()));
            SNPInfo snpinfo1 = this.snpSet.getSNPInfo((int)Math.floor(variables[0] / 2));
            if (snpinfo1 == null) {
                --draw;
            } else {
                variables[1] = this.findAnAppropriateVariableToPairWithThisOne(variables[0]);
                if (!this.processValidPairs(variables)) {
                    --draw;
                }
            }
            ++draw;
        }
        System.out.println("Finished.");
        this.outputter.Close();
    }

    public boolean processValidPairs(int[] variables) {
        if (variables[0] == -1 || variables[1] == -1) {
            return false;
        }
        int order = variables.length;
        int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variables);
        double pvalueCaseOnly = this.searcher.significance.TestCasesOnly(order, noOfCaseCarriers);
        int[][] noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variables);
        double pvalueCaseControl = this.searcher.significance.TestCasesVsControls(order, noOfCaseCarriers, noOfControlCarriers);
        if (variables[0] == variables[1] || variables[0] - variables[1] == 1 && variables[0] % 2 == 1 && variables[1] % 2 == 0 || variables[1] - variables[0] == 1 && variables[1] % 2 == 1 && variables[0] % 2 == 0) {
            pvalueCaseControl = 1.0;
        }
        this.outputter.WriteOutput(variables, noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl);
        return true;
    }
}

