/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import datastructures.Interaction;
import datastructures.SNPInfo;
import datastructures.VariableList;
import io.OutputWriter;
import io.SxpcFileReader;
import java.io.IOException;
import java.util.HashMap;
import pac.SearchDatastructure;

public class ClusterResults {
    private SearchDatastructure searcher;
    private OutputWriter outputter;
    private Interaction[] entries;

    public ClusterResults(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
    }

    private void readHitsFile(String hitsFileName) {
        try {
            SxpcFileReader s = new SxpcFileReader();
            this.entries = s.readProcessedHitsFile(hitsFileName);
            if (this.entries == null) {
                System.out.println("Nothing to process.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private HashMap<VariableList, HashMap<VariableList, Integer>> clusterInteractions(Interaction[] unclustered) {
        HashMap<VariableList, HashMap<VariableList, Integer>> hashtree = new HashMap<VariableList, HashMap<VariableList, Integer>>();
        boolean addedLevel1 = false;
        boolean addedLevel2 = false;
        double windowSize = this.searcher.userParams.getBlockSizeBp();
        Interaction[] interactionArray = unclustered;
        int n = unclustered.length;
        int n2 = 0;
        while (n2 < n) {
            Interaction current = interactionArray[n2];
            long[] current_bp = current.getBpdistance();
            int[] current_chr = current.getChromosome();
            int[] current_snps = current.getMapfileIndex();
            String[] current_modes = current.getMode();
            int[] current_vars = new int[2];
            int i = 0;
            while (i < 2) {
                int offset = current_modes[0].compareTo("d") == 0 ? 0 : 1;
                current_vars[i] = 2 * (current_snps[i] - 1) + offset;
                ++i;
            }
            addedLevel1 = false;
            addedLevel2 = false;
            for (VariableList var1 : hashtree.keySet()) {
                SNPInfo snp1 = this.searcher.snpList[var1.medianVariable() / 2];
                if (current_chr[0] != snp1.getChromosome() || (double)Math.abs(current_bp[0] - (long)snp1.getBp_distance()) > windowSize) continue;
                HashMap<VariableList, Integer> subtree = hashtree.get(var1);
                var1.addVariable(current_vars[0]);
                for (VariableList var2 : subtree.keySet()) {
                    SNPInfo snp2 = this.searcher.snpList[var2.medianVariable() / 2];
                    if (current_chr[1] != snp2.getChromosome() || (double)Math.abs(current_bp[1] - (long)snp2.getBp_distance()) > windowSize) continue;
                    Integer value = subtree.get(var2) + 1;
                    var2.addVariable(current_vars[1]);
                    subtree.put(var2, value);
                    addedLevel2 = true;
                    break;
                }
                if (!addedLevel2) {
                    VariableList new_level2 = new VariableList(current_vars[1]);
                    subtree.put(new_level2, 1);
                }
                hashtree.put(var1, subtree);
                addedLevel1 = true;
                break;
            }
            if (!addedLevel1) {
                VariableList new_level1 = new VariableList(current_vars[0]);
                VariableList new_level2 = new VariableList(current_vars[1]);
                HashMap<VariableList, Integer> subtree = new HashMap<VariableList, Integer>();
                subtree.put(new_level2, 1);
                hashtree.put(new_level1, subtree);
            }
            ++n2;
        }
        return hashtree;
    }

    public void doClustering(String hitsFileName) throws IOException {
        this.readHitsFile(hitsFileName);
        HashMap<VariableList, HashMap<VariableList, Integer>> hashtree = this.clusterInteractions(this.entries);
        for (VariableList var1 : hashtree.keySet()) {
            HashMap<VariableList, Integer> subtree = hashtree.get(var1);
            for (VariableList var2 : subtree.keySet()) {
                Integer count = subtree.get(var2);
                int[] variableArray = new int[]{var1.medianVariable(), var2.medianVariable()};
                int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variableArray);
                double pvalueCaseOnly = this.searcher.significance.TestCasesOnly(2, noOfCaseCarriers);
                int[][] noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variableArray);
                double pvalueCaseControl = this.searcher.significance.TestCasesVsControls(2, noOfCaseCarriers, noOfControlCarriers);
                try {
                    this.outputter.WriteOutputClustered(variableArray, noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl, count);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println("Finished.");
        this.outputter.Close();
    }
}

