/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import datastructures.UserParameters;
import pac.KeyGen;
import statistics.AbstractStatisticTests;
import statistics.D_Contrasts;
import statistics.ExactTest;
import statistics.IStatisticalTest;
import statistics.LOD_Contrasts;
import statistics.Phi_Contrasts;
import statistics.R_Contrasts;

public class SignificanceHelper
extends AbstractStatisticTests {
    private static final int allOrders = 4;
    private static double[] p_cutoff = new double[4];
    public static int[][] significanceListCases;
    static KeyGen keygen;
    private ExactTest exactTest;
    private IStatisticalTest asymptoticTest;
    private double MIN_CASES = 4.0;
    private double MIN_CONTROLS = 4.0;

    static {
        keygen = new KeyGen(10000);
    }

    public SignificanceHelper(UserParameters userParams) {
        super(userParams);
        String testName = userParams.getTestName();
        if (testName.compareTo("D") == 0) {
            this.asymptoticTest = new D_Contrasts(userParams);
        } else if (testName.compareTo("R") == 0) {
            this.asymptoticTest = new R_Contrasts(userParams);
        } else if (testName.compareTo("lod") == 0) {
            this.asymptoticTest = new LOD_Contrasts(userParams);
            this.initializeBoundaryConditionsForExactTest(1, 1);
        } else if (testName.compareTo("phi") == 0) {
            this.asymptoticTest = new Phi_Contrasts(userParams);
        } else {
            System.err.println("No such test. Using default R-contrast ... ");
        }
        this.exactTest = new ExactTest(this.asymptoticTest, userParams);
    }

    public void initializeBoundaryConditionsForExactTest(int min_cases, int min_controls) {
        this.MIN_CASES = min_cases;
        this.MIN_CONTROLS = min_controls;
    }

    public double[] calculatePvalCutoffs(UserParameters userParams) {
        p_cutoff = new double[4];
        int denominator = 1;
        long numerator = 1L;
        long combinations = 1L;
        int order = 1;
        while (order <= 4) {
            if (userParams.getSignificanceThreshold() != 1.0) {
                SignificanceHelper.p_cutoff[order - 1] = userParams.getSignificanceThreshold();
            } else {
                combinations = (numerator *= (long)(2 * userParams.getNumber_of_snps() - order)) / (long)(denominator *= order);
                SignificanceHelper.p_cutoff[order - 1] = 0.05 * (double)userParams.getLenience() / (double)combinations;
            }
            ++order;
        }
        return p_cutoff;
    }

    public double getCaseOnlyThreshold(int order) {
        double baseExponent = 1.0;
        double pvalue = Math.pow(p_cutoff[order - 1], baseExponent);
        return pvalue;
    }

    public double getCaseControlThreshold(int order) {
        double pvalue = p_cutoff[order - 1];
        return pvalue;
    }

    public double TestCasesOnly(int order, int[][] observedCases) {
        double probability = 1.0;
        if (!((double)observedCases[1][1] < this.MIN_CASES || (double)observedCases[1][0] < this.MIN_CASES || (double)observedCases[0][1] < this.MIN_CASES || (double)observedCases[0][0] < this.MIN_CASES)) {
            probability = this.asymptoticTest.TestCasesOnly(order, observedCases);
        } else if (this.testRare) {
            probability = this.exactTest.TestCasesOnly(order, observedCases);
        }
        return probability;
    }

    public double TestCasesVsControls(int order, int[][] observedCases, int[][] observedControls) {
        double probability = 1.0;
        if (!((double)observedCases[1][1] < this.MIN_CASES || (double)observedCases[1][0] < this.MIN_CASES || (double)observedCases[0][1] < this.MIN_CASES || (double)observedCases[0][0] < this.MIN_CASES || (double)observedControls[1][1] < this.MIN_CONTROLS || (double)observedControls[1][0] < this.MIN_CONTROLS || (double)observedControls[0][1] < this.MIN_CONTROLS || (double)observedControls[0][0] < this.MIN_CONTROLS)) {
            probability = this.asymptoticTest.TestCasesVsControls(order, observedCases, observedControls);
        } else if (this.testRare) {
            probability = this.exactTest.TestCasesVsControls(order, observedCases, observedControls);
        }
        return probability;
    }

    public double[] asymptoticAndExact_CaseOnly(int order, int[][] observedCases) {
        double[] bothPvalues = new double[]{this.asymptoticTest.TestCasesOnly(order, observedCases), this.exactTest.TestCasesOnly(order, observedCases)};
        return bothPvalues;
    }

    public double[] asymptoticAndExact_CaseVsControl(int order, int[][] observedCases, int[][] observedControls) {
        double[] bothPvalues = new double[]{this.asymptoticTest.TestCasesVsControls(order, observedCases, observedControls), this.exactTest.TestCasesVsControls(order, observedCases, observedControls)};
        return bothPvalues;
    }
}

