/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import datastructures.UserParameters;

public abstract class AbstractStatisticTests {
    protected final UserParameters userParams;
    protected final int totalCases;
    protected final int totalControls;
    protected final boolean testRare;

    public AbstractStatisticTests(UserParameters userparams) {
        this.userParams = userparams;
        this.totalCases = userparams.getNumber_of_cases();
        this.totalControls = userparams.getNumber_of_controls();
        this.testRare = userparams.toTestRare();
    }

    public int[][] make2DArray(int[] singleD) {
        int[][] multiD = new int[2][2];
        multiD[1][1] = singleD[3];
        multiD[1][0] = singleD[2];
        multiD[0][1] = singleD[1];
        multiD[0][0] = singleD[0];
        return multiD;
    }

    public int[] make1DArray(int[][] multiD) {
        int[] singleD = new int[4];
        singleD[3] = multiD[1][1];
        singleD[2] = multiD[1][0];
        singleD[1] = multiD[0][1];
        singleD[0] = multiD[0][0];
        return singleD;
    }

    public double[][] computeExpectations(int[][] observations) {
        int total = observations[1][1] + observations[1][0] + observations[0][1] + observations[0][0];
        double P = (double)(observations[1][1] + observations[1][0]) / (double)total;
        double Q = (double)(observations[1][1] + observations[0][1]) / (double)total;
        double[][] expectations = new double[2][2];
        expectations[1][1] = P * Q * (double)total;
        expectations[1][0] = P * (1.0 - Q) * (double)total;
        expectations[0][1] = (1.0 - P) * Q * (double)total;
        expectations[0][0] = (1.0 - P) * (1.0 - Q) * (double)total;
        return expectations;
    }
}

