/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import pac.SearchDatastructure;

public class WindowingSystem {
    private final int lastWindow = 79;
    private final double[][] windowBoundaries = new double[79][2];
    public BitSet[][] caseGenotypes;
    public HashMap<Integer, Integer>[] globalPositionHash;
    public int[] counter;

    public WindowingSystem() {
        double upper;
        double lower = 0.0;
        int i = 0;
        while (i < 3) {
            upper = Math.pow(10.0, i - 5);
            this.windowBoundaries[i][0] = lower;
            this.windowBoundaries[i][1] = upper;
            lower = this.windowBoundaries[i][1];
            ++i;
        }
        i = 3;
        while (i < 78) {
            upper = lower + 0.010121621621621621;
            this.windowBoundaries[i][0] = lower;
            this.windowBoundaries[i][1] = upper;
            lower = this.windowBoundaries[i][1];
            ++i;
        }
        this.windowBoundaries[78][0] = lower;
        this.windowBoundaries[78][1] = 0.8;
        this.counter = new int[79];
        this.globalPositionHash = new HashMap[79];
        i = 0;
        while (i < 79) {
            this.globalPositionHash[i] = new HashMap();
            ++i;
        }
    }

    public static double Dom(double maf) {
        return 2.0 * maf * (1.0 - maf) + WindowingSystem.Rec(maf);
    }

    public static double Rec(double maf) {
        return maf * maf;
    }

    public double[][] getWindowBoundaries() {
        return this.windowBoundaries;
    }

    public int getNoOfWindows() {
        return 79;
    }

    public double[][] getExpectedCases(int[] coordinates, int numberOfCases) {
        double[][] expectedCases = new double[2][2];
        switch (coordinates.length) {
            case 1: {
                double p_min = this.windowBoundaries[coordinates[0]][0];
                expectedCases[1][1] = (double)numberOfCases * p_min;
                expectedCases[1][0] = (double)numberOfCases - expectedCases[1][1];
                break;
            }
            default: {
                double p_min = this.windowBoundaries[coordinates[0]][0];
                double q_min = this.windowBoundaries[coordinates[1]][0];
                expectedCases[1][1] = (double)numberOfCases * p_min * q_min;
                expectedCases[1][0] = (double)numberOfCases * p_min * (1.0 - q_min);
                expectedCases[0][1] = (double)numberOfCases * (1.0 - p_min) * q_min;
                expectedCases[0][0] = (double)numberOfCases - expectedCases[1][1] - expectedCases[1][0] - expectedCases[0][1];
            }
        }
        return expectedCases;
    }

    public int[] whichMask(double maf) {
        int[] domAndRecMask = new int[]{-1, -1};
        double recf = WindowingSystem.Rec(maf);
        double domf = WindowingSystem.Dom(maf);
        int i = 0;
        while (i < this.windowBoundaries.length) {
            if (this.windowBoundaries[i][0] <= recf && this.windowBoundaries[i][1] > recf) {
                domAndRecMask[1] = i;
            }
            if (this.windowBoundaries[i][0] <= domf && this.windowBoundaries[i][1] > domf) {
                domAndRecMask[0] = i;
                break;
            }
            ++i;
        }
        return domAndRecMask;
    }

    private int[] whichMask(int[] domAndRecCarrierCounts, int cohortSize) {
        int[] domAndRecMask = new int[]{-1, -1};
        double domFreq = (double)domAndRecCarrierCounts[0] / (double)cohortSize;
        double recFreq = (double)domAndRecCarrierCounts[1] / (double)cohortSize;
        int i = 0;
        while (i < this.windowBoundaries.length) {
            if (domFreq != 0.0 && this.windowBoundaries[i][0] <= domFreq && domFreq < this.windowBoundaries[i][1]) {
                domAndRecMask[0] = i;
            }
            ++i;
        }
        i = 0;
        while (i < this.windowBoundaries.length) {
            if (recFreq != 0.0 && this.windowBoundaries[i][0] <= recFreq && recFreq < this.windowBoundaries[i][1]) {
                domAndRecMask[1] = i;
            }
            ++i;
        }
        return domAndRecMask;
    }

    public void makeWindowedGenomesFromData(SearchDatastructure searcher) {
        int numberOfSNPs = searcher.userParams.getNumber_of_snps();
        this.caseGenotypes = new BitSet[79][searcher.userParams.getNumber_of_cases()];
        Vector[] windowAssignedVariables = new Vector[79];
        int i = 0;
        while (i < 79) {
            windowAssignedVariables[i] = new Vector();
            ++i;
        }
        int wastedDomFeatures = 0;
        int wastedRecFeatures = 0;
        int snp = 0;
        while (snp < numberOfSNPs) {
            int[] domThenRecCarriers = new int[2];
            int indiv = 0;
            while (indiv < searcher.controlGenotypes.length) {
                if (searcher.controlGenotypes[indiv].get(2 * snp)) {
                    domThenRecCarriers[0] = domThenRecCarriers[0] + 1;
                }
                if (searcher.controlGenotypes[indiv].get(2 * snp + 1)) {
                    domThenRecCarriers[1] = domThenRecCarriers[1] + 1;
                }
                ++indiv;
            }
            searcher.snpList[snp].setControlDomCarriers(domThenRecCarriers[0]);
            searcher.snpList[snp].setControlRecCarriers(domThenRecCarriers[1]);
            domThenRecCarriers[0] = 0;
            domThenRecCarriers[1] = 0;
            indiv = 0;
            while (indiv < searcher.caseGenotypes.length) {
                if (searcher.caseGenotypes[indiv].get(2 * snp)) {
                    domThenRecCarriers[0] = domThenRecCarriers[0] + 1;
                }
                if (searcher.caseGenotypes[indiv].get(2 * snp + 1)) {
                    domThenRecCarriers[1] = domThenRecCarriers[1] + 1;
                }
                ++indiv;
            }
            searcher.snpList[snp].setCaseDomCarriers(domThenRecCarriers[0]);
            searcher.snpList[snp].setCaseRecCarriers(domThenRecCarriers[1]);
            int[] domThenRecIndex = this.whichMask(domThenRecCarriers, searcher.caseGenotypes.length);
            if (domThenRecIndex[0] != -1) {
                windowAssignedVariables[domThenRecIndex[0]].add(2 * snp);
            } else {
                ++wastedDomFeatures;
            }
            if (domThenRecIndex[1] != -1) {
                windowAssignedVariables[domThenRecIndex[1]].add(2 * snp + 1);
            } else {
                ++wastedRecFeatures;
            }
            ++snp;
        }
        System.out.println("Discarded " + wastedDomFeatures + " dom variables and " + wastedRecFeatures + " rec variables (carried by 0 cases).");
        int window = 0;
        while (window < 79) {
            int numberOfVariables = windowAssignedVariables[window].size();
            int indiv = 0;
            while (indiv < searcher.userParams.getNumber_of_cases()) {
                this.caseGenotypes[window][indiv] = new BitSet(numberOfVariables);
                this.caseGenotypes[window][indiv].clear();
                ++indiv;
            }
            Iterator iterator = windowAssignedVariables[window].iterator();
            while (iterator.hasNext()) {
                int varNo = (Integer)iterator.next();
                int indiv2 = 0;
                while (indiv2 < searcher.userParams.getNumber_of_cases()) {
                    if (searcher.caseGenotypes[indiv2].get(varNo)) {
                        this.caseGenotypes[window][indiv2].set(this.counter[window], this.counter[window] + 1);
                    }
                    ++indiv2;
                }
                this.globalPositionHash[window].put(this.counter[window], varNo);
                int n = window;
                this.counter[n] = this.counter[n] + 1;
            }
            ++window;
        }
    }
}

