/*
 * Decompiled with CFR 0.152.
 */
package preprocessing;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.ExpectedCasesCalculator;
import gridmath.ExpectedControlsCalculator;
import gridmath.FrequencyCalculator;
import gridmath.MatrixOperations;
import gridmath.MaxCaseCalculator;
import gridmath.NeededCaseCalculator;
import pac.SearchDatastructure;
import preprocessing.WindowingSystem;

public class SimpleConstraintHandler {
    private final UserParameters userParams;
    private final WindowingSystem windowMaker;
    private final SearchDatastructure searcher;
    private final CaseMatrixBase pSignificantMatrix;

    public SimpleConstraintHandler(SearchDatastructure I) throws Exception {
        this.searcher = I;
        this.userParams = this.searcher.userParams;
        this.windowMaker = this.searcher.windowMaker;
        System.out.println("Making frequency hypergrid ... ");
        FrequencyCalculator frequencyGrid = new FrequencyCalculator(this.userParams, this.windowMaker);
        frequencyGrid.compute(MatrixOperations.calculateFrequency, new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder()), true);
        System.out.println("Calculating expected Controls and Cases for various allelic combinations ... ");
        ExpectedCasesCalculator expectedCases = new ExpectedCasesCalculator(this.userParams, this.windowMaker);
        expectedCases.compute(MatrixOperations.calculateExpectedCases, frequencyGrid, true);
        ExpectedControlsCalculator expectedControls = new ExpectedControlsCalculator(this.userParams, this.windowMaker);
        expectedControls.compute(MatrixOperations.calculateExpectedControls, frequencyGrid, true);
        System.out.println("Calculating case carriers needed for significance ... ");
        NeededCaseCalculator neededCases = new NeededCaseCalculator(this.userParams, this.windowMaker, this.searcher.significance);
        neededCases.compute(MatrixOperations.calculateNeededCases, expectedCases, true);
        CaseMatrixBase tooManyCasesForSignificance = new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder(), this.userParams.getNumber_of_cases());
        neededCases.compute(MatrixOperations.lessThan, tooManyCasesForSignificance, true);
        System.out.println("Screening out SNPs whose maximal overlap will not make significance ... ");
        MaxCaseCalculator maxCases = new MaxCaseCalculator(this.userParams, this.windowMaker);
        maxCases.compute(MatrixOperations.calculateMaxCases, frequencyGrid, true);
        maxCases.compute(MatrixOperations.matrixMultiply, new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder(), this.userParams.getNumber_of_cases()), true);
        neededCases.compute(MatrixOperations.lessThan, maxCases, true);
        neededCases.compute(MatrixOperations.greaterThan, new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder(), 1.0), true);
        System.out.println("Calculating probability matrix assuming interactions at levels needed for significance ...");
        double denominator = 1.0 / (double)this.userParams.getNumber_of_cases();
        this.pSignificantMatrix = neededCases.compute(MatrixOperations.matrixMultiply, new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder(), denominator), false);
    }

    public CaseMatrixBase getPSignificantMatrix() {
        return this.pSignificantMatrix;
    }

    public CaseMatrixBase getPLEMatrix() {
        FrequencyCalculator pLEMatrix = new FrequencyCalculator(this.userParams, this.windowMaker);
        pLEMatrix.compute(MatrixOperations.calculateFrequency, new CaseMatrixBase(this.windowMaker, this.userParams.getMaxorder()), true);
        return pLEMatrix;
    }
}

