/*
 * Decompiled with CFR 0.152.
 */
package pac;

import datastructures.WorkUnit;
import io.OutputWriter;
import java.util.BitSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import pac.KeyGen;
import pac.SearchDatastructure;

public class WorkHorse {
    private WorkUnit regionToSearch;
    private final SearchDatastructure searcher;
    private OutputWriter outputter;
    private Map<Double, Boolean> stage1Candidates = new ConcurrentHashMap<Double, Boolean>(10000, 0.95f);
    private Map<Double, Boolean> stage2AlreadyTested = new ConcurrentHashMap<Double, Boolean>();
    private final double maxHashableCandidates;
    private double numberOfTrials;
    private int totalNumberOfCandidates;
    private KeyGen keygen;
    int order;
    private final double caseOnlyCutoff;
    private final double caseControlCutoff;

    public WorkHorse(WorkUnit searchRegion, SearchDatastructure I, OutputWriter O) {
        this.regionToSearch = searchRegion;
        this.searcher = I;
        this.outputter = O;
        this.maxHashableCandidates = this.searcher.userParams.getMaxHeapPerThread() * 10000;
        this.keygen = new KeyGen(2 * this.searcher.snpList.length);
        this.totalNumberOfCandidates = 0;
        this.order = 2;
        this.caseOnlyCutoff = this.searcher.significance.getCaseOnlyThreshold(this.order);
        this.caseControlCutoff = this.searcher.significance.getCaseControlThreshold(this.order);
    }

    public int requiredSamples() {
        return this.regionToSearch.getTotalRequiredTrials();
    }

    public int candidatesTested() {
        return this.totalNumberOfCandidates;
    }

    public boolean doSampling() {
        System.out.println("Sampling " + this.regionToSearch.getTotalRequiredTrials() + " times ... ");
        int[] windowsToSearch = this.regionToSearch.getCoordinates();
        int[] trial_spectrum = this.regionToSearch.getRequiredTrials();
        double[] power_spectrum = this.regionToSearch.getPowerDistribution();
        int Cases = this.searcher.userParams.getNumber_of_cases();
        int lengthOfBitSet1 = 2 * this.searcher.windowMaker.counter[windowsToSearch[0]];
        int lengthOfBitSet2 = 2 * this.searcher.windowMaker.counter[windowsToSearch[1]];
        BitSet result1 = new BitSet(lengthOfBitSet1);
        BitSet result2 = new BitSet(lengthOfBitSet2);
        int[][] snpIndices = new int[2][];
        Random randomizer = new Random((long)Math.floor(this.searcher.userParams.getRandomSeed()));
        int k = 0;
        while (k < trial_spectrum.length) {
            if (trial_spectrum[k] >= 1) {
                System.out.println(String.valueOf(trial_spectrum[k]) + " samples @ k=" + k + ". Power=" + power_spectrum[k]);
                int max_trials_for_this_k = trial_spectrum[k];
                this.numberOfTrials = 0.0;
                while (this.numberOfTrials < (double)max_trials_for_this_k && (double)this.stage1Candidates.size() < this.maxHashableCandidates) {
                    result1.set(0, lengthOfBitSet1 + 1);
                    result2.set(0, lengthOfBitSet2 + 1);
                    int index = 0;
                    while (index < k) {
                        int pick = (int)Math.floor(randomizer.nextDouble() * (double)Cases);
                        result1.and(this.searcher.windowMaker.caseGenotypes[windowsToSearch[0]][pick]);
                        result2.and(this.searcher.windowMaker.caseGenotypes[windowsToSearch[1]][pick]);
                        ++index;
                    }
                    int window1entries = result1.cardinality();
                    int window2entries = result2.cardinality();
                    if (window1entries != 0 && window2entries != 0) {
                        int snpNo;
                        snpIndices[0] = new int[window1entries];
                        snpIndices[1] = new int[window2entries];
                        int bitNo = -1;
                        int entry = 0;
                        while (entry < window1entries) {
                            bitNo = result1.nextSetBit(bitNo + 1);
                            snpIndices[0][entry] = snpNo = this.searcher.windowMaker.globalPositionHash[windowsToSearch[0]].get(bitNo).intValue();
                            ++entry;
                        }
                        bitNo = -1;
                        entry = 0;
                        while (entry < window2entries) {
                            bitNo = result2.nextSetBit(bitNo + 1);
                            snpIndices[1][entry] = snpNo = this.searcher.windowMaker.globalPositionHash[windowsToSearch[1]].get(bitNo).intValue();
                            ++entry;
                        }
                        int entry0 = 0;
                        while (entry0 < snpIndices[0].length) {
                            int variable0 = snpIndices[0][entry0];
                            double block0 = this.searcher.snpList[(int)Math.floor(variable0 / 2)].getBlockNo();
                            int entry1 = 0;
                            while (entry1 < snpIndices[1].length) {
                                int variable1 = snpIndices[1][entry1];
                                double block1 = this.searcher.snpList[(int)Math.floor(variable1 / 2)].getBlockNo();
                                if (Math.abs(block1 - block0) >= 1.0) {
                                    int[] nArray;
                                    if (variable0 < variable1) {
                                        int[] nArray2 = new int[2];
                                        nArray2[0] = variable0;
                                        nArray = nArray2;
                                        nArray2[1] = variable1;
                                    } else {
                                        int[] nArray3 = new int[2];
                                        nArray3[0] = variable1;
                                        nArray = nArray3;
                                        nArray3[1] = variable0;
                                    }
                                    int[] variableArray = nArray;
                                    double key = this.keygen.makeKey(variableArray);
                                    this.stage1Candidates.put(key, true);
                                }
                                ++entry1;
                            }
                            ++entry0;
                        }
                    }
                    this.numberOfTrials += 1.0;
                    int n = k;
                    trial_spectrum[n] = trial_spectrum[n] - 1;
                }
                if ((double)this.stage1Candidates.size() >= this.maxHashableCandidates) {
                    --k;
                    this.doFollowUp();
                }
            }
            ++k;
        }
        if (this.regionToSearch.getTotalRequiredTrials() == 0) {
            this.doFollowUp();
            return true;
        }
        return false;
    }

    public void doFollowUp() {
        if (this.stage1Candidates.size() == 0) {
            return;
        }
        this.totalNumberOfCandidates += this.stage1Candidates.size();
        System.out.println("Testing " + this.totalNumberOfCandidates + " candidates ... ");
        for (Double entry : this.stage1Candidates.keySet()) {
            int[][] noOfControlCarriers;
            double pvalueCaseControl;
            int[] variableArray = this.keygen.breakKey(entry);
            int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variableArray);
            double pvalueCaseOnly = this.searcher.significance.TestCasesOnly(this.order, noOfCaseCarriers);
            if (pvalueCaseOnly > this.caseOnlyCutoff || !((pvalueCaseControl = this.searcher.significance.TestCasesVsControls(this.order, noOfCaseCarriers, noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variableArray))) <= this.caseControlCutoff) || this.stage2AlreadyTested.get(entry) != null) continue;
            this.outputter.WriteOutput(variableArray, noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl);
            this.stage2AlreadyTested.put(entry, true);
        }
        this.stage1Candidates.clear();
    }
}

