/*
 * Decompiled with CFR 0.152.
 */
package pac;

import datastructures.CarrierIndex;
import datastructures.Individual;
import datastructures.IndividualInfo;
import datastructures.SNPInfo;
import datastructures.UserParameters;
import io.PlinkFileException;
import io.PlinkFilereader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import preprocessing.WindowingSystem;
import statistics.SignificanceHelper;

public class SearchDatastructure {
    public final long seed = 1000L;
    public long startTimeMs;
    public volatile long stage1Candidates;
    public volatile long stage1Trials;
    public volatile long stage1Time;
    public volatile long stage2Time;
    public final UserParameters userParams;
    public WindowingSystem windowMaker;
    public SNPInfo[] snpList;
    public BitSet[] snpMasks;
    public CarrierIndex snpIndices;
    public IndividualInfo[] caseInfo;
    public IndividualInfo[] controlInfo;
    public BitSet[] caseGenotypes;
    public BitSet[] controlGenotypes;
    public final SignificanceHelper significance;
    public volatile Map<String, Integer> shortlistedCandidates = Collections.synchronizedMap(new HashMap());

    public SearchDatastructure(UserParameters userParameters, WindowingSystem windowingSystem) throws Exception {
        this.userParams = userParameters;
        this.windowMaker = windowingSystem;
        this.getCasesAndControls();
        this.getMapFile();
        System.out.println(String.valueOf(this.caseInfo.length) + " cases, " + this.controlInfo.length + " controls.");
        DecimalFormat doubleF = new DecimalFormat("#.###");
        System.out.println(String.valueOf(this.snpList.length) + " SNPs. Testing 4 interaction models per SNP-pair.");
        System.out.println("Approximately " + doubleF.format((double)this.snpList.length * (double)(this.snpList.length - 1) * 0.5 * 1.0E-6 * 4.0) + " million pairwise tests. \n");
        System.out.println("Calculating significance vectors ... ");
        this.significance = new SignificanceHelper(this.userParams);
        this.significance.calculatePvalCutoffs(this.userParams);
        this.assignCarrierStatusToSNPs();
        this.assignSNPsToMasks();
        this.setupLDBlockSize();
        Runtime r = Runtime.getRuntime();
        r.gc();
        long used_mem = r.totalMemory() - r.freeMemory();
        System.out.println("Heap space used up by dataset: " + (float)used_mem / 1000000.0f + " Mb");
    }

    private void setupLDBlockSize() throws IOException, PlinkFileException {
        PlinkFilereader filereader = new PlinkFilereader();
        if (this.userParams.getBlockSizeBp() != -1.0f) {
            this.padSNPBlocks(this.userParams.getBlockSizeBp(), 1);
        } else if (this.userParams.getBlockSizeCm() != -1.0f) {
            this.padSNPBlocks(this.userParams.getBlockSizeCm(), 2);
        } else {
            boolean foundBlockFile = filereader.readBlockFile(this.userParams.getBlockfilename(), this.snpList);
            if (!foundBlockFile || this.userParams.getBlockSizeBp() != -1.0f && this.userParams.getBlockSizeCm() != -1.0f) {
                this.padSNPBlocks(0.0f, 3);
            }
        }
    }

    private void assignSNPsToMasks() throws IOException, PlinkFileException {
        this.windowMaker.makeWindowedGenomesFromData(this);
        this.caseGenotypes = null;
        this.controlGenotypes = null;
        System.gc();
    }

    private void assignCarrierStatusToSNPs() {
        System.out.println("Indexing datasets (this may take a while) ... ");
        int numberOfCases = this.caseGenotypes.length;
        int numberOfControls = this.controlGenotypes.length;
        int numberOfSNPs = this.snpList.length;
        this.snpIndices = new CarrierIndex(numberOfSNPs * 2);
        int snp = 0;
        while (snp < this.snpList.length) {
            BitSet caseDomEntries = new BitSet(numberOfCases);
            BitSet caseRecEntries = new BitSet(numberOfCases);
            int indiv = 0;
            while (indiv < numberOfCases) {
                if (this.caseGenotypes[indiv].get(2 * snp + 1)) {
                    caseDomEntries.set(indiv);
                    caseRecEntries.set(indiv);
                } else if (this.caseGenotypes[indiv].get(2 * snp)) {
                    caseDomEntries.set(indiv);
                }
                ++indiv;
            }
            this.snpIndices.setCaseCarrierIndex(caseDomEntries, 2 * snp);
            this.snpIndices.setCaseCarrierIndex(caseRecEntries, 2 * snp + 1);
            BitSet controlDomEntries = new BitSet(numberOfControls);
            BitSet controlRecEntries = new BitSet(numberOfControls);
            int indiv2 = 0;
            while (indiv2 < numberOfControls) {
                if (this.controlGenotypes[indiv2].get(2 * snp + 1)) {
                    controlDomEntries.set(indiv2);
                    controlRecEntries.set(indiv2);
                } else if (this.controlGenotypes[indiv2].get(2 * snp)) {
                    controlDomEntries.set(indiv2);
                }
                ++indiv2;
            }
            this.snpIndices.setControlCarrierIndex(controlDomEntries, 2 * snp);
            this.snpIndices.setControlCarrierIndex(controlRecEntries, 2 * snp + 1);
            ++snp;
        }
    }

    private void getMapFile() throws IOException, PlinkFileException {
        PlinkFilereader filereader = new PlinkFilereader();
        this.snpList = filereader.readMapfile(this.userParams.getMapfilename());
        if (this.snpList.length != this.caseInfo[0].getNumberOfSNPs()) {
            throw new PlinkFileException("Raw and Map files are incompatible");
        }
        this.userParams.setNumber_of_snps(this.snpList.length);
    }

    private void getCasesAndControls() throws IOException, PlinkFileException {
        Individual[] tempControls;
        Individual[] tempCases;
        PlinkFilereader filereader = new PlinkFilereader();
        if (this.userParams.getAllRawfilename().compareTo("") != 0) {
            Individual[] allIndividuals = filereader.readRawFile(this.userParams.getAllRawfilename());
            Vector<Individual[]> casesAndControls = filereader.segregateCasesAndControls(allIndividuals, this.userParams.getPhenofilename(), false);
            tempCases = casesAndControls.elementAt(0);
            tempControls = casesAndControls.elementAt(1);
        } else {
            tempCases = filereader.readRawFile(this.userParams.getCasefilename());
            tempControls = filereader.readRawFile(this.userParams.getControlfilename());
        }
        this.caseInfo = new IndividualInfo[tempCases.length];
        this.controlInfo = new IndividualInfo[tempControls.length];
        this.caseGenotypes = new BitSet[tempCases.length];
        int i = 0;
        while (i < tempCases.length) {
            this.caseInfo[i] = tempCases[i].getIndividualInfo();
            this.caseGenotypes[i] = tempCases[i].getGenotype();
            ++i;
        }
        this.userParams.setNumber_of_cases(this.caseGenotypes.length);
        if (tempControls != null) {
            this.controlGenotypes = new BitSet[tempControls.length];
            i = 0;
            while (i < tempControls.length) {
                this.controlInfo[i] = tempControls[i].getIndividualInfo();
                this.controlGenotypes[i] = tempControls[i].getGenotype();
                ++i;
            }
            this.userParams.setNumber_of_controls(this.controlGenotypes.length);
        } else {
            this.controlGenotypes = null;
        }
    }

    private void padSNPBlocks(float windowSize, int mode) {
        block4: {
            block5: {
                block3: {
                    if (mode != 3) break block3;
                    int i = 0;
                    while (i < this.snpList.length) {
                        this.snpList[i].setBlockNo(i);
                        ++i;
                    }
                    break block4;
                }
                if (mode != 2) break block5;
                int i = 0;
                while (i < this.snpList.length) {
                    double offset = this.snpList[i].getCm_distance() / (double)windowSize;
                    double base = (double)this.snpList[i].getChromosome() * 100000.0;
                    double windowNo = base + offset;
                    this.snpList[i].setBlockNo(windowNo);
                    ++i;
                }
                break block4;
            }
            if (mode != 1) break block4;
            int i = 0;
            while (i < this.snpList.length) {
                float offset = (float)this.snpList[i].getBp_distance() / windowSize;
                float base = (float)this.snpList[i].getChromosome() * (2.0E8f / windowSize);
                float windowNo = base + offset;
                this.snpList[i].setBlockNo(windowNo);
                ++i;
            }
        }
    }
}

