/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import datastructures.MapfileWrapper;
import io.OutputWriter;
import io.SxpcFileReader;
import java.io.IOException;
import java.util.Vector;
import pac.SearchDatastructure;

public class TestCombinations {
    private SearchDatastructure searcher;
    private OutputWriter outputter;
    private MapfileWrapper snpSet;
    private Vector<String[]> variables;

    public TestCombinations(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
        this.snpSet = new MapfileWrapper(this.searcher.snpList);
    }

    private void readHitsFile(String hitsFileName) {
        try {
            SxpcFileReader s = new SxpcFileReader();
            this.variables = s.readUnprocessedHitsFile(hitsFileName);
            if (this.variables == null) {
                System.out.println("Nothing to process.");
                System.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private int[][] getVariablesAroundSpan(int[] pivotVariables) {
        int totalVariables = this.searcher.userParams.getSpan() + 1 + this.searcher.userParams.getSpan();
        int[] Xaxis = new int[totalVariables];
        int[] Yaxis = new int[totalVariables];
        int i = this.searcher.userParams.getSpan();
        while (i > 0) {
            Xaxis[this.searcher.userParams.getSpan() - i] = pivotVariables[0] - 2 * i;
            Yaxis[this.searcher.userParams.getSpan() - i] = pivotVariables[1] - 2 * i;
            --i;
        }
        Xaxis[this.searcher.userParams.getSpan()] = pivotVariables[0];
        Yaxis[this.searcher.userParams.getSpan()] = pivotVariables[1];
        i = 1;
        while (i <= this.searcher.userParams.getSpan()) {
            Xaxis[this.searcher.userParams.getSpan() + i] = pivotVariables[0] + 2 * i;
            Yaxis[this.searcher.userParams.getSpan() + i] = pivotVariables[1] + 2 * i;
            ++i;
        }
        int[][] variableArray = new int[totalVariables * totalVariables][2];
        int i2 = 0;
        while (i2 < Xaxis.length) {
            int j = 0;
            while (j < Yaxis.length) {
                variableArray[i2 * totalVariables + j][0] = Xaxis[i2];
                variableArray[i2 * totalVariables + j][1] = Yaxis[j];
                ++j;
            }
            ++i2;
        }
        return variableArray;
    }

    private String[][] getRowAndColLabels(int[] pivotVariables) {
        String mode;
        int currentVariable;
        String[][] rowAndColLabels = new String[2][2 * this.searcher.userParams.getSpan() + 1];
        int row_var = -2 * this.searcher.userParams.getSpan();
        while (row_var <= 2 * this.searcher.userParams.getSpan()) {
            currentVariable = pivotVariables[0] + row_var;
            int row = (2 * this.searcher.userParams.getSpan() + row_var) / 2;
            mode = currentVariable % 2 == 0 ? "d" : "r";
            rowAndColLabels[0][row] = String.valueOf(this.snpSet.getSNPInfo((int)Math.floor(currentVariable / 2)).getRsid()) + "," + mode;
            row_var += 2;
        }
        int col_var = -2 * this.searcher.userParams.getSpan();
        while (col_var <= 2 * this.searcher.userParams.getSpan()) {
            currentVariable = pivotVariables[1] + col_var;
            int col = (2 * this.searcher.userParams.getSpan() + col_var) / 2;
            mode = currentVariable % 2 == 0 ? "d" : "r";
            rowAndColLabels[1][col] = String.valueOf(this.snpSet.getSNPInfo((int)Math.floor(currentVariable / 2)).getRsid()) + "," + mode;
            col_var += 2;
        }
        return rowAndColLabels;
    }

    public void getSignificance(String hitsFileName) throws IOException {
        this.readHitsFile(hitsFileName);
        int[][] variableArray = new int[this.variables.size()][2];
        double[][] pvalMatrix = new double[this.variables.size()][1];
        if (this.searcher.userParams.getSpan() == 0) {
            int hit = 0;
            while (hit < this.variables.size()) {
                variableArray[hit] = this.snpSet.interactionToVariables(this.variables.elementAt(hit));
                ++hit;
            }
        } else {
            int[] pivotVariables = this.snpSet.interactionToVariables(this.variables.elementAt(0));
            variableArray = this.getVariablesAroundSpan(pivotVariables);
            pvalMatrix = new double[2 * this.searcher.userParams.getSpan() + 1][2 * this.searcher.userParams.getSpan() + 1];
        }
        int len = 0;
        while (len < variableArray.length) {
            int order = variableArray[len].length;
            int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variableArray[len]);
            double pvalueCaseOnly = this.searcher.significance.TestCasesOnly(order, noOfCaseCarriers);
            int[][] noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variableArray[len]);
            double pvalueCaseControl = this.searcher.significance.TestCasesVsControls(order, noOfCaseCarriers, noOfControlCarriers);
            if (variableArray[len][0] == variableArray[len][1] || variableArray[len][0] - variableArray[len][1] == 1 && variableArray[len][0] % 2 == 1 && variableArray[len][1] % 2 == 0 || variableArray[len][1] - variableArray[len][0] == 1 && variableArray[len][1] % 2 == 1 && variableArray[len][0] % 2 == 0) {
                pvalueCaseControl = 1.0;
            }
            if (this.searcher.userParams.getSpan() == 0) {
                this.outputter.WriteOutput(variableArray[len], noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl);
            } else {
                pvalMatrix[(int)Math.floor((double)((double)len / (double)(2 * this.searcher.userParams.getSpan() + 1)))][len % (2 * this.searcher.userParams.getSpan() + 1)] = pvalueCaseControl;
            }
            ++len;
        }
        if (this.searcher.userParams.getSpan() != 0) {
            int[] pivotVariables = this.snpSet.interactionToVariables(this.variables.elementAt(0));
            String[][] rowAndColLabels = this.getRowAndColLabels(pivotVariables);
            this.outputter.writeOutputMatrix(pvalMatrix, rowAndColLabels);
        }
        System.out.println("Finished.");
        this.outputter.Close();
    }
}

