/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import io.OutputWriter;
import java.io.IOException;
import pac.SearchDatastructure;

public class CompleteSearch {
    private SearchDatastructure searcher;
    private OutputWriter outputter;

    public CompleteSearch(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
    }

    public void doBruteForcePairwiseSearch() throws IOException {
        this.searcher.startTimeMs = System.currentTimeMillis();
        int lengthOfBitSet = 2 * this.searcher.snpList.length;
        int progress = 1;
        int snp1 = 1;
        while (snp1 < lengthOfBitSet) {
            int snp2 = 0;
            while (snp2 < snp1) {
                int[][] noOfControlCarriers;
                int order = 2;
                int[] nArray = new int[]{snp1, snp2};
                int[] variableArray = nArray;
                int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variableArray);
                double pvalueCaseControl = this.searcher.significance.TestCasesVsControls(order, noOfCaseCarriers, noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variableArray));
                if (pvalueCaseControl <= this.searcher.significance.getCaseControlThreshold(order)) {
                    this.outputter.WriteOutput(variableArray, noOfCaseCarriers, 1.0, noOfControlCarriers, pvalueCaseControl);
                }
                ++snp2;
            }
            if ((double)snp1 > (double)progress * (double)lengthOfBitSet / 100.0) {
                System.out.println("Finished " + Math.pow(progress, 2.0) / 100.0 + "% in " + (System.currentTimeMillis() - this.searcher.startTimeMs) / 1000L + " seconds.");
                ++progress;
            }
            ++snp1;
        }
        this.outputter.Close();
        System.out.println("=========");
        System.out.println("Done.");
        System.out.println("Interactions found are listed in " + this.searcher.userParams.getStage2Output());
        System.out.println("=========");
    }
}

