/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import io.OutputWriter;
import java.io.IOException;
import pac.SearchDatastructure;

public class ApproxCompleteSearch {
    private SearchDatastructure searcher;
    private OutputWriter outputter;

    public ApproxCompleteSearch(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
    }

    public void doApproximatePairwiseSearch() throws IOException {
        this.searcher.startTimeMs = System.currentTimeMillis();
        int lengthOfBitSet = 2 * this.searcher.snpList.length;
        int progress = 1;
        int snp1 = 1;
        while (snp1 < lengthOfBitSet) {
            int snp2 = 0;
            while (snp2 < snp1) {
                int[][] noOfControlCarriers;
                double pvalueCaseControl;
                int[] variableArray;
                int[][] noOfCaseCarriers;
                double pvalueCaseOnly;
                int chr1 = this.searcher.snpList[(int)Math.floor(snp1 / 2)].getChromosome();
                int chr2 = this.searcher.snpList[(int)Math.floor(snp2 / 2)].getChromosome();
                double cm1 = this.searcher.snpList[(int)Math.floor(snp1 / 2)].getCm_distance();
                double cm2 = this.searcher.snpList[(int)Math.floor(snp2 / 2)].getCm_distance();
                if (!(chr1 == chr2 && Math.abs(cm1 - cm2) < (double)this.searcher.userParams.getBlockSizeCm() || (pvalueCaseOnly = this.searcher.significance.TestCasesOnly(2, noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variableArray = new int[]{snp1, snp2}))) > this.searcher.significance.getCaseOnlyThreshold(2) || !((pvalueCaseControl = this.searcher.significance.TestCasesVsControls(2, noOfCaseCarriers, noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variableArray))) <= this.searcher.significance.getCaseControlThreshold(2)))) {
                    this.outputter.WriteOutput(variableArray, noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl);
                }
                ++snp2;
            }
            if ((double)snp1 > (double)progress * (double)lengthOfBitSet / 100.0) {
                System.out.println("Finished " + Math.pow(progress, 2.0) / 100.0 + "% in " + (System.currentTimeMillis() - this.searcher.startTimeMs) / 1000L + " seconds.");
                ++progress;
            }
            ++snp1;
        }
        this.outputter.Close();
        System.out.println("=========");
        System.out.println("Done.");
        System.out.println("Interactions found are listed in " + this.searcher.userParams.getStage2Output());
        System.out.println("=========");
    }
}

