/*
 * Decompiled with CFR 0.152.
 */
package algorithm;

import datastructures.MapfileWrapper;
import datastructures.SNPInfo;
import io.OutputWriter;
import io.PlinkFilereader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import pac.SearchDatastructure;

public class ApplyMap {
    private SearchDatastructure searcher;
    private OutputWriter outputter;
    private MapfileWrapper snpSet;

    public ApplyMap(SearchDatastructure I, OutputWriter O) throws IOException {
        this.searcher = I;
        this.outputter = O;
        this.snpSet = new MapfileWrapper(this.searcher.snpList);
    }

    public void applyGeneticMap() throws IOException {
        PlinkFilereader pf = new PlinkFilereader();
        Map<String, Double> snpToCm = pf.readGeneticMapfile(this.searcher.userParams.getGeneticMapFile());
        FileWriter fstream = new FileWriter(this.searcher.userParams.getStage2Output(), false);
        BufferedWriter bwriter = new BufferedWriter(fstream);
        SNPInfo[] mappedSNPs = new SNPInfo[this.snpSet.getNumberOfSNPs()];
        int index = 0;
        while (index < this.snpSet.getNumberOfSNPs()) {
            mappedSNPs[index] = this.snpSet.getSNPInfo(index);
            Double cmdistance = snpToCm.get(mappedSNPs[index].getRsid());
            if (cmdistance == null) {
                cmdistance = 0.0;
            }
            mappedSNPs[index].setCm_distance(cmdistance);
            bwriter.write(String.valueOf(mappedSNPs[index].toStringMapFormat()) + "\n");
            bwriter.flush();
            ++index;
        }
        System.out.println("Finished.");
        this.outputter.Close();
    }

    public boolean processValidPairs(int[] variables) {
        if (variables[0] == -1 || variables[1] == -1) {
            return false;
        }
        int order = variables.length;
        int[][] noOfCaseCarriers = this.searcher.snpIndices.getObservedCaseCarriers(this.searcher.userParams, variables);
        double pvalueCaseOnly = this.searcher.significance.TestCasesOnly(order, noOfCaseCarriers);
        int[][] noOfControlCarriers = this.searcher.snpIndices.getObservedControlCarriers(this.searcher.userParams, variables);
        double pvalueCaseControl = this.searcher.significance.TestCasesVsControls(order, noOfCaseCarriers, noOfControlCarriers);
        if (variables[0] == variables[1] || variables[0] - variables[1] == 1 && variables[0] % 2 == 1 && variables[1] % 2 == 0 || variables[1] - variables[0] == 1 && variables[1] % 2 == 1 && variables[0] % 2 == 0) {
            pvalueCaseControl = 1.0;
        }
        this.outputter.WriteOutput(variables, noOfCaseCarriers, pvalueCaseOnly, noOfControlCarriers, pvalueCaseControl);
        return true;
    }
}

