/*
 * Decompiled with CFR 0.152.
 */
package statistics;

import datastructures.UserParameters;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pac.KeyGen;
import statistics.AbstractStatisticTests;
import statistics.IStatisticalTest;

public class ExactTest
extends AbstractStatisticTests {
    static BigDecimal[] lnFactorialList = new BigDecimal[5000];
    private IStatisticalTest asymptoticTest;
    private static KeyGen keygen;
    private static volatile Map<Double, BigDecimal> configurationToPointProbability;
    private static volatile Map<Double, BigDecimal> configurationToCummulativeProbability;

    static {
        ExactTest.lnFactorialList[0] = new BigDecimal("0").setScale(100);
        int i = 1;
        while (i < 5000) {
            BigDecimal number = new BigDecimal(Math.log(i)).setScale(100);
            ExactTest.lnFactorialList[i] = lnFactorialList[i - 1].add(number);
            ++i;
        }
        keygen = new KeyGen(10000);
        configurationToPointProbability = new ConcurrentHashMap<Double, BigDecimal>();
        configurationToCummulativeProbability = new ConcurrentHashMap<Double, BigDecimal>();
    }

    public ExactTest(IStatisticalTest testOfChoice, UserParameters userParams) {
        super(userParams);
        this.asymptoticTest = testOfChoice;
    }

    private static BigDecimal choose(int m, int k) {
        if (k < 0 || k > m) {
            return new BigDecimal(1);
        }
        BigDecimal numerator = new BigDecimal(1).setScale(100);
        BigDecimal denominator = new BigDecimal(1).setScale(100);
        int greater = k >= m - k ? k : m - k;
        int lesser = k < m - k ? k : m - k;
        int i = m;
        while (i > greater) {
            numerator = numerator.multiply(new BigDecimal(i));
            --i;
        }
        i = lesser;
        while (i > 0) {
            denominator = denominator.multiply(new BigDecimal(i));
            --i;
        }
        BigDecimal m_choose_k = numerator.divide(denominator, 4);
        return m_choose_k.setScale(100);
    }

    private static int[] configUp(int[] configuration) {
        configuration[0] = configuration[0] + 1;
        configuration[1] = configuration[1] - 1;
        configuration[2] = configuration[2] - 1;
        configuration[3] = configuration[3] + 1;
        return configuration;
    }

    private static int[] configDown(int[] configuration) {
        configuration[0] = configuration[0] - 1;
        configuration[1] = configuration[1] + 1;
        configuration[2] = configuration[2] + 1;
        configuration[3] = configuration[3] - 1;
        return configuration;
    }

    private int[] minConfig(int[] config) {
        int[] configuration = (int[])config.clone();
        int delta = Math.min(configuration[0], configuration[3]);
        configuration[0] = configuration[0] - delta;
        configuration[1] = configuration[1] + delta;
        configuration[2] = configuration[2] + delta;
        configuration[3] = configuration[3] - delta;
        return configuration;
    }

    private static BigDecimal calculatePointEventProbability(int[] config) {
        int[] configuration = (int[])config.clone();
        double key = keygen.makeKey(configuration);
        BigDecimal probability = configurationToPointProbability.get(key);
        if (probability == null) {
            int m = configuration[0] + configuration[1];
            int N_minus_m = configuration[2] + configuration[3];
            int N = m + N_minus_m;
            int n = configuration[0] + configuration[2];
            int k = configuration[0];
            int n_minus_k = n - k;
            BigDecimal numerator = ExactTest.choose(m, k).multiply(ExactTest.choose(N_minus_m, n_minus_k));
            BigDecimal denominator = ExactTest.choose(N, n);
            probability = numerator.divide(denominator, 4);
            configurationToPointProbability.put(key, probability);
        }
        return probability;
    }

    private static BigDecimal calculateCummulativeEventProbability(int[] config) {
        int[] configuration = (int[])config.clone();
        double key = keygen.makeKey(configuration);
        BigDecimal cumm_probability = configurationToCummulativeProbability.get(key);
        if (cumm_probability == null) {
            cumm_probability = new BigDecimal("0");
            while (ExactTest.isValid(configuration)) {
                BigDecimal probability = ExactTest.calculatePointEventProbability(configuration);
                cumm_probability = cumm_probability.add(probability);
                configuration = ExactTest.configDown(configuration);
            }
            configurationToCummulativeProbability.put(key, cumm_probability);
        }
        return cumm_probability;
    }

    public double TestCasesOnly(int order, int[][] observedCases) {
        int[] configuration = this.make1DArray(observedCases);
        BigDecimal pValue = new BigDecimal("0");
        while (ExactTest.isValid(configuration)) {
            pValue = pValue.add(ExactTest.calculatePointEventProbability(configuration));
            configuration = ExactTest.configUp(configuration);
        }
        return pValue.doubleValue();
    }

    public double TestCasesVsControls(int order, int[][] observedCases, int[][] observedControls) {
        double boundaryZscore = this.asymptoticTest.TestCasesVsControls_Zscore(order, observedCases, observedControls);
        if (boundaryZscore < 0.0) {
            int[][] temp = observedCases;
            observedCases = observedControls;
            observedControls = temp;
            boundaryZscore = -boundaryZscore;
        }
        int[] case_configuration = this.make1DArray(observedCases);
        int[] control_configuration = this.make1DArray(observedControls);
        BigDecimal exactPvalue = new BigDecimal("0");
        double currentZscore = 0.0;
        case_configuration = this.minConfig(case_configuration);
        while (ExactTest.isValid(case_configuration)) {
            int[][] control_config_2D;
            int[][] case_config_2D = this.make2DArray(case_configuration);
            control_configuration = this.minConfig(control_configuration);
            while (ExactTest.isValid(control_configuration)) {
                control_config_2D = this.make2DArray(control_configuration);
                currentZscore = this.asymptoticTest.TestCasesVsControls_Zscore(order, case_config_2D, control_config_2D);
                if (currentZscore < boundaryZscore) break;
                control_configuration = ExactTest.configUp(control_configuration);
            }
            control_configuration = ExactTest.configDown(control_configuration);
            if (!ExactTest.isValid(control_configuration)) {
                control_configuration = ExactTest.configUp(control_configuration);
            }
            if ((currentZscore = this.asymptoticTest.TestCasesVsControls_Zscore(order, case_config_2D, control_config_2D = this.make2DArray(control_configuration))) >= boundaryZscore && ExactTest.isValid(case_configuration) && ExactTest.isValid(control_configuration)) {
                BigDecimal casePointProbability = ExactTest.calculatePointEventProbability(case_configuration);
                BigDecimal controlCummulativeProbability = ExactTest.calculateCummulativeEventProbability(control_configuration);
                BigDecimal configurationPvalue = casePointProbability.multiply(controlCummulativeProbability);
                exactPvalue = exactPvalue.add(configurationPvalue);
            }
            case_configuration = ExactTest.configUp(case_configuration);
        }
        return exactPvalue.doubleValue();
    }

    private static boolean isValid(int[] configuration) {
        return configuration[0] >= 0 && configuration[1] >= 0 && configuration[2] >= 0 && configuration[3] >= 0;
    }
}

