/*
 * Decompiled with CFR 0.152.
 */
package pac;

import datastructures.WorkUnit;
import io.OutputWriter;
import pac.SearchDatastructure;
import pac.WorkHorse;

public class SamplingThread
implements Runnable {
    private WorkUnit regionToSearch;
    private final SearchDatastructure searcher;
    private int thread_number;
    private OutputWriter outputter;

    public SamplingThread(WorkUnit searchRegion, SearchDatastructure I, int threadNo, OutputWriter O) {
        this.regionToSearch = searchRegion;
        this.searcher = I;
        this.thread_number = threadNo;
        this.outputter = O;
    }

    @Override
    public void run() {
        System.out.println("\nStarting thread " + this.thread_number + ": " + this.regionToSearch.toStringBrief());
        System.out.println("Brute force = " + this.regionToSearch.getBruteForceCombinationsInRegion() + " tests.");
        System.out.println("Expecting < " + (long)this.regionToSearch.getWorstExpectedCombinationsFromRegion() + " candidates.");
        WorkHorse stage1sampler = new WorkHorse(this.regionToSearch, this.searcher, this.outputter);
        boolean finished = false;
        long stage1TimeSpent = 0L;
        long stage2TimeSpent = 0L;
        long numberOfStage1Candidates = 0L;
        long numberOfTrialsFinished = 0L;
        long timeBeforeStage1 = System.currentTimeMillis();
        int trialsPerformed = stage1sampler.requiredSamples();
        finished = stage1sampler.doSampling();
        if (!finished) {
            System.err.println("<Shyte> BROKEN BUILD! \n Thread quit before full scan. </Shyte>");
            System.exit(1);
        }
        int candidatesTested = stage1sampler.candidatesTested();
        long timeAfterStage1 = System.currentTimeMillis();
        this.printPerformance(numberOfStage1Candidates += (long)candidatesTested, numberOfTrialsFinished += (long)trialsPerformed, stage1TimeSpent += timeAfterStage1 - timeBeforeStage1, stage2TimeSpent);
        stage1sampler = null;
    }

    public void printPerformance(long numberOfStage1Candidates, long numberOfTrialsFinished, double stage1TimeSpent, double stage2TimeSpent) {
        double absoluteFactorSavings = (double)this.regionToSearch.getBruteForceCombinationsInRegion() / (double)numberOfStage1Candidates;
        double amortizedFactorSavings = (double)this.searcher.userParams.getPower() * absoluteFactorSavings;
        System.out.println("Pruning factor = " + absoluteFactorSavings + " (absolute), " + amortizedFactorSavings + " (amortized)");
        this.searcher.stage1Candidates += numberOfStage1Candidates;
        this.searcher.stage1Trials += numberOfTrialsFinished;
        this.searcher.stage1Time = (long)((double)this.searcher.stage1Time + stage1TimeSpent);
        this.searcher.stage2Time = (long)((double)this.searcher.stage2Time + stage2TimeSpent);
        System.out.println("Time taken by Thread " + this.thread_number + " = " + stage1TimeSpent / 1000.0 + " seconds.");
        System.out.println("Cummulative time spent so far: " + (System.currentTimeMillis() - this.searcher.startTimeMs) / 1000L + " seconds.");
    }
}

