/*
 * Decompiled with CFR 0.152.
 */
package io;

import datastructures.Individual;
import datastructures.IndividualInfo;
import datastructures.PhenotypeInfo;
import datastructures.SNPInfo;
import datastructures.UserParameters;
import io.PlinkFileException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import preprocessing.WindowingSystem;

public class PlinkFilereader {
    public static final int MAX_INDIVIDUALS = 5000;
    public static final int MAX_GENOTYPES = 2000000;

    public Individual[] readRawFile(String rawFile) throws IOException {
        System.out.println("Reading RAW file: " + rawFile);
        BufferedReader reader = new BufferedReader(new FileReader(rawFile));
        reader.readLine();
        Vector<Individual> rawFileContents = new Vector<Individual>();
        String text = null;
        while ((text = reader.readLine()) != null) {
            StringTokenizer rawTokenizer = new StringTokenizer(text);
            String FAM_ID = new String(rawTokenizer.nextToken());
            String IND_ID = new String(rawTokenizer.nextToken());
            String PAT_ID = new String(rawTokenizer.nextToken());
            String MAT_ID = new String(rawTokenizer.nextToken());
            String Sex2 = new String(rawTokenizer.nextToken());
            String Phenotype2 = new String(rawTokenizer.nextToken());
            int genotype_count = 0;
            BitSet genotypeBitSet = new BitSet();
            while (rawTokenizer.hasMoreTokens()) {
                int position = 2 * genotype_count;
                String nextToken = rawTokenizer.nextToken();
                if (nextToken.compareTo("0") == 0) {
                    genotypeBitSet.clear(position, position + 2);
                } else if (nextToken.compareTo("1") == 0) {
                    genotypeBitSet.set(position, position + 1);
                    genotypeBitSet.clear(position + 1, position + 2);
                } else if (nextToken.compareTo("2") == 0) {
                    genotypeBitSet.set(position, position + 2);
                } else if (nextToken.compareTo("NA") == 0) {
                    genotypeBitSet.clear(position, position + 2);
                }
                ++genotype_count;
            }
            rawTokenizer = null;
            rawFileContents.add(new Individual(FAM_ID, IND_ID, PAT_ID, MAT_ID, Sex2, Phenotype2, genotype_count, genotypeBitSet));
        }
        Individual[] individuals = new Individual[rawFileContents.size()];
        rawFileContents.toArray(individuals);
        reader.close();
        return individuals;
    }

    public Vector<Individual[]> segregateCasesAndControls(Individual[] allIndividuals, String phenoFile, boolean permute) throws IOException, PlinkFileException {
        Vector<Individual> cases = new Vector<Individual>();
        Vector<Individual> controls = new Vector<Individual>();
        allIndividuals = !permute ? this.resolvePhenotypeStatus(allIndividuals, phenoFile) : this.randomizePhenotypeStatus(allIndividuals);
        int indiv = 0;
        while (indiv < allIndividuals.length) {
            if (allIndividuals[indiv].getIndividualInfo().getPhenotype().compareTo("2") == 0) {
                cases.add(allIndividuals[indiv]);
            } else if (allIndividuals[indiv].getIndividualInfo().getPhenotype().compareTo("1") == 0) {
                controls.add(allIndividuals[indiv]);
            }
            ++indiv;
        }
        Individual[] casesArray = new Individual[cases.size()];
        cases.toArray(casesArray);
        Individual[] controlsArray = new Individual[controls.size()];
        controls.toArray(controlsArray);
        Vector<Individual[]> casesAndControls = new Vector<Individual[]>();
        casesAndControls.add(casesArray);
        casesAndControls.add(controlsArray);
        return casesAndControls;
    }

    public Individual[] randomizePhenotypeStatus(Individual[] allIndividuals) throws PlinkFileException {
        int number_of_cases = 0;
        int number_of_controls = 0;
        Individual[] individualArray = allIndividuals;
        int n = allIndividuals.length;
        int n2 = 0;
        while (n2 < n) {
            Individual individual = individualArray[n2];
            if (individual.getIndividualInfo().getPhenotype().compareTo("2") == 0) {
                ++number_of_cases;
            } else if (individual.getIndividualInfo().getPhenotype().compareTo("1") == 0) {
                ++number_of_controls;
            }
            ++n2;
        }
        Random rand = new Random();
        double cutoff = (double)number_of_cases / (double)(number_of_cases + number_of_controls);
        Individual[] individualArray2 = allIndividuals;
        int n3 = allIndividuals.length;
        int n4 = 0;
        while (n4 < n3) {
            Individual individual = individualArray2[n4];
            if (rand.nextDouble() < cutoff) {
                individual.getIndividualInfo().setPhenotype("2");
            } else {
                individual.getIndividualInfo().setPhenotype("1");
            }
            ++n4;
        }
        return allIndividuals;
    }

    private Individual[] resolvePhenotypeStatus(Individual[] allIndividuals, String phenoFile) throws PlinkFileException {
        PhenotypeInfo[] phenotypeMembership = null;
        if (phenoFile.compareTo("") == 0) {
            return allIndividuals;
        }
        try {
            phenotypeMembership = this.readPhenofile(phenoFile);
        }
        catch (IOException e) {
            System.err.println("Trouble reading phenotype file ... continuing with phenotypes provided in raw file.");
            return allIndividuals;
        }
        if (allIndividuals.length != phenotypeMembership.length) {
            throw new PlinkFileException("Phenotype file and Raw file individual IDs don't match");
        }
        int count = 0;
        while (count < allIndividuals.length) {
            if (allIndividuals[count].getIndividualInfo().getFAM_ID().compareTo(phenotypeMembership[count].getFAM_ID()) == 0 && allIndividuals[count].getIndividualInfo().getIND_ID().compareTo(phenotypeMembership[count].getIND_ID()) == 0) {
                IndividualInfo currentInfo = allIndividuals[count].getIndividualInfo();
                currentInfo.setPhenotype(phenotypeMembership[count].getPhenotype());
                allIndividuals[count].setIndividualInfo(currentInfo);
            }
            ++count;
        }
        return allIndividuals;
    }

    public static BitSet StringArrayToBitSet(String[] genotypeList) throws PlinkFileException {
        int numberOfSNPs = genotypeList == null ? 0 : genotypeList.length;
        BitSet genotypeVector = new BitSet(numberOfSNPs * 2);
        genotypeVector.clear();
        int index = 0;
        while (index < numberOfSNPs) {
            int sum;
            StringTokenizer genotypeTokenizer = new StringTokenizer(genotypeList[index], " ");
            String first = genotypeTokenizer.nextToken();
            String[] alleles = genotypeTokenizer.hasMoreTokens() ? new String[]{first, genotypeTokenizer.nextToken()} : new String[]{first};
            int position = 2 * index;
            if (alleles.length == 1) {
                sum = Integer.parseInt(alleles[0]);
            } else if (alleles.length == 2) {
                sum = Integer.parseInt(alleles[0]) + Integer.parseInt(alleles[1]) - 2;
            } else {
                throw new PlinkFileException("Bad file format");
            }
            switch (sum) {
                case 0: {
                    break;
                }
                case 1: {
                    genotypeVector.set(position, position + 1);
                    break;
                }
                default: {
                    genotypeVector.set(position, position + 2);
                }
            }
            ++index;
        }
        return genotypeVector;
    }

    public SNPInfo[] readMapfile(String mapFile) throws IOException {
        SNPInfo[] mostRecentlyReadMapFile = null;
        Vector<SNPInfo> filecontents = new Vector<SNPInfo>();
        System.out.println("Reading MAP file: " + mapFile);
        BufferedReader reader = new BufferedReader(new FileReader(mapFile));
        String text = null;
        while ((text = reader.readLine()) != null) {
            String[] mapLine = text.split("\\s+");
            SNPInfo snp = new SNPInfo(Integer.parseInt(mapLine[0]), mapLine[1], Double.parseDouble(mapLine[2]), Integer.parseInt(mapLine[3]));
            filecontents.add(snp);
        }
        mostRecentlyReadMapFile = new SNPInfo[filecontents.size()];
        filecontents.toArray(mostRecentlyReadMapFile);
        reader.close();
        return mostRecentlyReadMapFile;
    }

    public Map<String, Double> readGeneticMapfile(String cmFile) throws IOException {
        HashMap<String, Double> filecontents = new HashMap<String, Double>();
        System.out.println("Reading Genetic Map file: " + cmFile);
        BufferedReader reader = new BufferedReader(new FileReader(cmFile));
        String text = null;
        while ((text = reader.readLine()) != null) {
            String[] mapLine = text.split("\\s+");
            filecontents.put(mapLine[1], Double.parseDouble(mapLine[2]));
        }
        return filecontents;
    }

    public PhenotypeInfo[] readPhenofile(String phenoFile) throws IOException {
        PhenotypeInfo[] mostRecentlyReadPhenoFile = null;
        Vector<PhenotypeInfo> filecontents = new Vector<PhenotypeInfo>();
        System.out.println("Reading Phenotype file: " + phenoFile);
        BufferedReader reader = new BufferedReader(new FileReader(phenoFile));
        String text = null;
        while ((text = reader.readLine()) != null) {
            String[] phenoLine = text.split("\\s+");
            PhenotypeInfo pheno = new PhenotypeInfo(phenoLine[0], phenoLine[1], phenoLine[2]);
            filecontents.add(pheno);
        }
        mostRecentlyReadPhenoFile = new PhenotypeInfo[filecontents.size()];
        filecontents.toArray(mostRecentlyReadPhenoFile);
        reader.close();
        return mostRecentlyReadPhenoFile;
    }

    public String[] readAvoidFile(String snpsToAvoidFile) throws IOException {
        Vector<String> filecontents = new Vector<String>();
        System.out.println("Reading SNPs to avoid file: " + snpsToAvoidFile + "...");
        BufferedReader reader = new BufferedReader(new FileReader(snpsToAvoidFile));
        String text = null;
        while ((text = reader.readLine()) != null) {
            String[] avoidSnpLine = text.split("\\s+");
            filecontents.add(avoidSnpLine[0]);
        }
        String[] returnArray = new String[filecontents.size()];
        filecontents.toArray(returnArray);
        reader.close();
        return returnArray;
    }

    public int[][] readSignificanceFile(String significanceFile) throws IOException {
        Vector<int[]> filecontents = new Vector<int[]>();
        System.out.println("Reading Significance file: " + significanceFile + "...");
        BufferedReader reader = new BufferedReader(new FileReader(significanceFile));
        String text = null;
        while ((text = reader.readLine()) != null) {
            String[] required = text.split("\\s+");
            int[] entries = new int[required.length];
            int i = 0;
            while (i < required.length) {
                entries[i] = Integer.parseInt(required[i]);
                ++i;
            }
            filecontents.add(entries);
        }
        int[][] returnArray = new int[filecontents.size()][];
        int entry = 0;
        while (entry < filecontents.size()) {
            returnArray[entry] = (int[])filecontents.elementAt(entry);
            ++entry;
        }
        return returnArray;
    }

    public BitSet[] readFrqFile(UserParameters userparams, WindowingSystem windowMaker, SNPInfo[] snpList) throws IOException, PlinkFileException {
        String frqFile = userparams.getFrqfilename();
        int freqWindows = userparams.getFreqWindows();
        BitSet[] masks = new BitSet[freqWindows];
        int i = 0;
        while (i < freqWindows) {
            masks[i] = new BitSet(snpList.length * 2);
            ++i;
        }
        System.out.println("\nReading FRQ file: " + frqFile + "...");
        BufferedReader reader = new BufferedReader(new FileReader(frqFile));
        String text = null;
        reader.readLine();
        int count = 0;
        while ((text = reader.readLine()) != null && count < snpList.length) {
            Pattern pattern = Pattern.compile("\\s+(.*?)\\s+(.*?)\\s+(.*?)\\s+(.*?)\\s+(.*?)\\s+(.*?)$");
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches()) {
                float maf = Float.parseFloat(matcher.group(5));
                int caseDomCarriers = (int)((float)userparams.getNumber_of_cases() * (2.0f * maf * (1.0f - maf) + maf * maf));
                int caseRecCarriers = (int)((float)userparams.getNumber_of_cases() * maf * maf);
                snpList[count].setCaseDomCarriers(caseDomCarriers);
                snpList[count].setCaseRecCarriers(caseRecCarriers);
                int controlDomCarriers = (int)((float)userparams.getNumber_of_controls() * (2.0f * maf * (1.0f - maf) + maf * maf));
                int controlRecCarriers = (int)((float)userparams.getNumber_of_controls() * maf * maf);
                snpList[count].setControlDomCarriers(controlDomCarriers);
                snpList[count].setControlRecCarriers(controlRecCarriers);
                int[] domThenRecIndex = windowMaker.whichMask(maf);
                snpList[count].setWhichMaskForDom(domThenRecIndex[0]);
                snpList[count].setWhichMaskForRec(domThenRecIndex[1]);
                if (domThenRecIndex[0] != -1) {
                    masks[domThenRecIndex[0]].set(2 * count, 2 * count + 1);
                }
                if (domThenRecIndex[1] != -1) {
                    masks[domThenRecIndex[1]].set(2 * count + 1, 2 * count + 2);
                }
            } else {
                throw new IOException("Could not parse ped file " + frqFile);
            }
            ++count;
        }
        if (reader.readLine() != null || count != snpList.length) {
            throw new PlinkFileException("FRQ and MAP files are incompatible");
        }
        reader.close();
        return masks;
    }

    public boolean readBlockFile(String blockFile, SNPInfo[] snpList) throws IOException, PlinkFileException {
        System.out.println("Searching for BLOCK file: " + blockFile + "...");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(blockFile));
            String text = null;
            int blockNo = 0;
            int lastEndIndex = -1;
            while ((text = reader.readLine()) != null) {
                String[] blocklist = text.split("\\s+");
                int startIndex = Integer.parseInt(blocklist[0]) - 1;
                int endIndex = Integer.parseInt(blocklist[blocklist.length - 1]) - 1;
                int filler = lastEndIndex + 1;
                while (filler < startIndex) {
                    snpList[filler].setBlockNo(blockNo);
                    ++blockNo;
                    ++filler;
                }
                int i = startIndex;
                while (i <= endIndex) {
                    snpList[i].setBlockNo(blockNo);
                    ++i;
                }
                lastEndIndex = endIndex;
                ++blockNo;
            }
            reader.close();
        }
        catch (IOException e) {
            System.out.println("Could not find compatible block file. Using default initialization.");
            return false;
        }
        return true;
    }

    public void readBedFile(String rawFile) throws IOException {
    }

    public void readFamFile(String rawFile) throws IOException {
    }
}

