/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.BitSet;
import pac.SearchDatastructure;
import statistics.SignificanceHelper;

public class OutputWriter {
    private SearchDatastructure searcher;
    private SignificanceHelper significanceHelper;
    private BufferedWriter bwriter;
    private DecimalFormat doubleF;
    private DecimalFormat twiceDoubleF;
    private DecimalFormat scientificF;

    public OutputWriter(SearchDatastructure I, SignificanceHelper S) throws IOException {
        this.searcher = I;
        this.significanceHelper = S;
        FileWriter fstream = new FileWriter(this.searcher.userParams.getStage2Output(), true);
        this.bwriter = new BufferedWriter(fstream);
        this.doubleF = new DecimalFormat("#.##");
        this.twiceDoubleF = new DecimalFormat("#.####");
        this.scientificF = new DecimalFormat("0.##E00");
    }

    private String getCaseCarrierIDs(int[] variableArray) {
        BitSet var1Cases = new BitSet();
        switch (variableArray.length) {
            case 1: {
                var1Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[0]);
                break;
            }
            case 2: {
                var1Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[0]);
                BitSet var2Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[1]);
                var1Cases.and(var2Cases);
                break;
            }
            case 3: {
                var1Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[0]);
                BitSet var2Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[1]);
                BitSet var3Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[2]);
                var1Cases.and(var2Cases);
                var1Cases.and(var3Cases);
                break;
            }
            default: {
                var1Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[0]);
                BitSet var2Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[1]);
                BitSet var3Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[2]);
                BitSet var4Cases = this.searcher.snpIndices.getCaseCarrierIndex(variableArray[3]);
                var1Cases.and(var2Cases);
                var1Cases.and(var3Cases);
                var1Cases.and(var4Cases);
            }
        }
        StringBuffer caseCarrierIDs = new StringBuffer();
        int i = var1Cases.nextSetBit(0);
        while (i >= 0) {
            caseCarrierIDs.append(String.valueOf(this.searcher.caseInfo[i].getIND_ID()) + ",");
            i = var1Cases.nextSetBit(i + 1);
        }
        return caseCarrierIDs.toString();
    }

    private String getControlCarrierIDs(int[] variableArray) {
        BitSet var1Controls = new BitSet();
        switch (variableArray.length) {
            case 1: {
                var1Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[0]);
                break;
            }
            case 2: {
                var1Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[0]);
                BitSet var2Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[1]);
                var1Controls.and(var2Controls);
                break;
            }
            case 3: {
                var1Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[0]);
                BitSet var2Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[1]);
                BitSet var3Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[2]);
                var1Controls.and(var2Controls);
                var1Controls.and(var3Controls);
                break;
            }
            default: {
                var1Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[0]);
                BitSet var2Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[1]);
                BitSet var3Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[2]);
                BitSet var4Controls = this.searcher.snpIndices.getControlCarrierIndex(variableArray[3]);
                var1Controls.and(var2Controls);
                var1Controls.and(var3Controls);
                var1Controls.and(var4Controls);
            }
        }
        StringBuffer controlCarrierIDs = new StringBuffer();
        int i = var1Controls.nextSetBit(0);
        while (i >= 0) {
            controlCarrierIDs.append(String.valueOf(this.searcher.controlInfo[i].getIND_ID()) + ",");
            i = var1Controls.nextSetBit(i + 1);
        }
        return controlCarrierIDs.toString();
    }

    private String getSNPDetailsfromVariables(int[] variableArray) {
        StringBuffer interactionString = new StringBuffer();
        int varNo = 0;
        while (varNo < 2) {
            int snpNo = (int)Math.floor(variableArray[varNo] / 2);
            char mode = variableArray[varNo] % 2 == 0 ? (char)'d' : 'r';
            interactionString.append(String.valueOf(snpNo + 1) + "," + mode + "," + this.searcher.snpList[snpNo].toString() + "\t");
            ++varNo;
        }
        return interactionString.toString();
    }

    private double[][] computeExpectations(int[][] observations) {
        int total = observations[1][1] + observations[1][0] + observations[0][1] + observations[0][0];
        double P = (double)(observations[1][1] + observations[1][0]) / (double)total;
        double Q = (double)(observations[1][1] + observations[0][1]) / (double)total;
        double[][] expectations = new double[2][2];
        expectations[1][1] = P * Q * (double)total;
        expectations[1][0] = P * (1.0 - Q) * (double)total;
        expectations[0][1] = (1.0 - P) * Q * (double)total;
        expectations[0][0] = (1.0 - P) * (1.0 - Q) * (double)total;
        return expectations;
    }

    private double[] getCaseAndControlDisequilibria(double[][] expectedCaseCarriers, int[][] noOfCaseCarriers, double[][] expectedControlCarriers, int[][] noOfControlCarriers) {
        double Dprime_cases = -999.0;
        double Dprime_controls = -999.0;
        if (expectedCaseCarriers[1][1] > 0.0 && expectedCaseCarriers[0][0] > 0.0 && expectedControlCarriers[1][1] > 0.0 && expectedControlCarriers[0][0] > 0.0) {
            double P = (expectedCaseCarriers[1][1] + expectedCaseCarriers[1][0]) / (double)this.searcher.userParams.getNumber_of_cases();
            double Q = (expectedCaseCarriers[1][1] + expectedCaseCarriers[0][1]) / (double)this.searcher.userParams.getNumber_of_cases();
            double Dcases = ((double)noOfCaseCarriers[1][1] - expectedCaseCarriers[1][1]) / (double)this.searcher.userParams.getNumber_of_cases();
            double Dcases_max = Dcases <= 0.0 ? Math.min(P * Q, (1.0 - P) * (1.0 - Q)) : Math.min(P * (1.0 - Q), (1.0 - P) * Q);
            Dprime_cases = Dcases / Dcases_max;
            double p = (expectedControlCarriers[1][1] + expectedControlCarriers[1][0]) / (double)this.searcher.userParams.getNumber_of_controls();
            double q = (expectedControlCarriers[1][1] + expectedControlCarriers[0][1]) / (double)this.searcher.userParams.getNumber_of_controls();
            double Dcontrols = ((double)noOfControlCarriers[1][1] - expectedControlCarriers[1][1]) / (double)this.searcher.userParams.getNumber_of_controls();
            double Dcontrols_max = Dcontrols <= 0.0 ? Math.min(p * q, (1.0 - p) * (1.0 - q)) : Math.min(p * (1.0 - q), (1.0 - p) * q);
            Dprime_controls = Dcontrols / Dcontrols_max;
        }
        return new double[]{Dprime_cases, Dprime_controls};
    }

    private synchronized void WriteOutputFull(int[] variableArray, double[][] expectedCaseCarriers, int[][] noOfCaseCarriers, double pvalueCaseOnly, double[][] expectedControlCarriers, int[][] noOfControlCarriers, double pvalueCaseControl) throws IOException {
        String interactionString = this.getSNPDetailsfromVariables(variableArray);
        double[] disequilibria = this.getCaseAndControlDisequilibria(expectedCaseCarriers, noOfCaseCarriers, expectedControlCarriers, noOfControlCarriers);
        String caseIDs = this.getCaseCarrierIDs(variableArray);
        String controlIDs = this.getControlCarrierIDs(variableArray);
        this.bwriter.write(String.valueOf(interactionString.toString()) + this.doubleF.format(expectedCaseCarriers[0][0]) + "/" + this.doubleF.format(expectedCaseCarriers[0][1]) + "/" + this.doubleF.format(expectedCaseCarriers[1][0]) + "/" + this.doubleF.format(expectedCaseCarriers[1][1]) + "\t" + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseOnly) + "\t" + this.doubleF.format(expectedControlCarriers[0][0]) + "/" + this.doubleF.format(expectedControlCarriers[0][1]) + "/" + this.doubleF.format(expectedControlCarriers[1][0]) + "/" + this.doubleF.format(expectedControlCarriers[1][1]) + "\t" + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseControl) + "\t" + this.twiceDoubleF.format(disequilibria[0]) + "\t" + this.twiceDoubleF.format(disequilibria[1]) + "\t" + caseIDs + "\t" + controlIDs + "\n");
        this.bwriter.flush();
    }

    private synchronized void WriteOutputNormal(int[] variableArray, double[][] expectedCaseCarriers, int[][] noOfCaseCarriers, double pvalueCaseOnly, double[][] expectedControlCarriers, int[][] noOfControlCarriers, double pvalueCaseControl) throws IOException {
        String interactionString = this.getSNPDetailsfromVariables(variableArray);
        double[] disequilibria = this.getCaseAndControlDisequilibria(expectedCaseCarriers, noOfCaseCarriers, expectedControlCarriers, noOfControlCarriers);
        this.bwriter.write(String.valueOf(interactionString.toString()) + this.doubleF.format(expectedCaseCarriers[0][0]) + "/" + this.doubleF.format(expectedCaseCarriers[0][1]) + "/" + this.doubleF.format(expectedCaseCarriers[1][0]) + "/" + this.doubleF.format(expectedCaseCarriers[1][1]) + "\t" + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseOnly) + "\t" + this.doubleF.format(expectedControlCarriers[0][0]) + "/" + this.doubleF.format(expectedControlCarriers[0][1]) + "/" + this.doubleF.format(expectedControlCarriers[1][0]) + "/" + this.doubleF.format(expectedControlCarriers[1][1]) + "\t" + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseControl) + "\t" + this.twiceDoubleF.format(disequilibria[0]) + "\t" + this.twiceDoubleF.format(disequilibria[1]) + "\n");
        this.bwriter.flush();
    }

    private synchronized void WriteOutputBrief(int[] variableArray, double[][] expectedCaseCarriers, int[][] noOfCaseCarriers, double pvalueCaseOnly, double[][] expectedControlCarriers, int[][] noOfControlCarriers, double pvalueCaseControl) throws IOException {
        String interactionString = this.getSNPDetailsfromVariables(variableArray);
        double[] disequilibria = this.getCaseAndControlDisequilibria(expectedCaseCarriers, noOfCaseCarriers, expectedControlCarriers, noOfControlCarriers);
        this.bwriter.write(String.valueOf(interactionString.toString()) + this.doubleF.format(expectedCaseCarriers[0][0]) + "/" + this.doubleF.format(expectedCaseCarriers[0][1]) + "/" + this.doubleF.format(expectedCaseCarriers[1][0]) + "/" + this.doubleF.format(expectedCaseCarriers[1][1]) + "\t" + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseOnly) + "\t" + this.doubleF.format(expectedControlCarriers[0][0]) + "/" + this.doubleF.format(expectedControlCarriers[0][1]) + "/" + this.doubleF.format(expectedControlCarriers[1][0]) + "/" + this.doubleF.format(expectedControlCarriers[1][1]) + "\t" + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseControl) + "\t" + this.twiceDoubleF.format(disequilibria[1]) + "\t" + this.twiceDoubleF.format(disequilibria[0]) + "\n");
        this.bwriter.flush();
    }

    public void WriteOutput(int[] variableArray, int[][] noOfCaseCarriers, double pvalueCaseOnly, int[][] noOfControlCarriers, double pvalueCaseControl) {
        double[] disequilibria;
        double[][] expectedCaseCarriers = this.computeExpectations(noOfCaseCarriers);
        double[][] expectedControlCarriers = this.computeExpectations(noOfControlCarriers);
        if (this.searcher.userParams.getSynergyOnly() && (disequilibria = this.getCaseAndControlDisequilibria(expectedCaseCarriers, noOfCaseCarriers, expectedControlCarriers, noOfControlCarriers))[0] - disequilibria[1] < 0.0) {
            return;
        }
        try {
            switch (this.searcher.userParams.getVerboseState()) {
                case 0: {
                    this.WriteOutputBrief(variableArray, expectedCaseCarriers, noOfCaseCarriers, pvalueCaseOnly, expectedControlCarriers, noOfControlCarriers, pvalueCaseControl);
                    break;
                }
                case 1: {
                    this.WriteOutputNormal(variableArray, expectedCaseCarriers, noOfCaseCarriers, pvalueCaseOnly, expectedControlCarriers, noOfControlCarriers, pvalueCaseControl);
                    break;
                }
                default: {
                    this.WriteOutputFull(variableArray, expectedCaseCarriers, noOfCaseCarriers, pvalueCaseOnly, expectedControlCarriers, noOfControlCarriers, pvalueCaseControl);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeOutputMatrix(double[][] pvalueMatrix, String[][] rowAndColLabels) throws IOException {
        this.bwriter.write("\t");
        int col = 0;
        while (col < rowAndColLabels[1].length) {
            this.bwriter.write(rowAndColLabels[1][col]);
            if (col != rowAndColLabels[1].length - 1) {
                this.bwriter.write("\t");
            } else {
                this.bwriter.write("\n");
            }
            ++col;
        }
        int i = 0;
        while (i < pvalueMatrix.length) {
            this.bwriter.write(String.valueOf(rowAndColLabels[0][i]) + "\t");
            int j = 0;
            while (j < pvalueMatrix[i].length) {
                this.bwriter.write(String.valueOf(-Math.log10(pvalueMatrix[i][j])) + "\t");
                ++j;
            }
            this.bwriter.write("\n");
            ++i;
        }
    }

    public synchronized void WriteOutputClustered(int[] variableArray, int[][] noOfCaseCarriers, double pvalueCaseOnly, int[][] noOfControlCarriers, double pvalueCaseControl, Integer countOfNearbyHits) throws IOException {
        double[][] expectedCaseCarriers = this.computeExpectations(noOfCaseCarriers);
        double[][] expectedControlCarriers = this.computeExpectations(noOfControlCarriers);
        int order = variableArray.length;
        String interactionString = this.getSNPDetailsfromVariables(variableArray);
        double[] disequilibria = this.getCaseAndControlDisequilibria(expectedCaseCarriers, noOfCaseCarriers, expectedControlCarriers, noOfControlCarriers);
        switch (order) {
            case 2: {
                this.bwriter.write(String.valueOf(interactionString.toString()) + this.doubleF.format(expectedCaseCarriers[0][0]) + "/" + this.doubleF.format(expectedCaseCarriers[0][1]) + "/" + this.doubleF.format(expectedCaseCarriers[1][0]) + "/" + this.doubleF.format(expectedCaseCarriers[1][1]) + "\t" + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseOnly) + "\t" + this.doubleF.format(expectedControlCarriers[0][0]) + "/" + this.doubleF.format(expectedControlCarriers[0][1]) + "/" + this.doubleF.format(expectedControlCarriers[1][0]) + "/" + this.doubleF.format(expectedControlCarriers[1][1]) + "\t" + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + "\t" + this.scientificF.format(pvalueCaseControl) + "\t" + this.twiceDoubleF.format(disequilibria[0]) + "\t" + this.twiceDoubleF.format(disequilibria[1]) + "\t" + countOfNearbyHits + "\n");
                break;
            }
            case 3: {
                this.bwriter.write(String.valueOf(interactionString.toString()) + expectedCaseCarriers[0][0] + "/" + expectedCaseCarriers[0][1] + "/" + expectedCaseCarriers[1][0] + "/" + expectedCaseCarriers[1][1] + expectedCaseCarriers[0][0] + "/" + expectedCaseCarriers[0][1] + "/" + expectedCaseCarriers[1][0] + "/" + expectedCaseCarriers[1][1] + "\t" + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + noOfCaseCarriers[0][0] + "/" + noOfCaseCarriers[0][1] + "/" + noOfCaseCarriers[1][0] + "/" + noOfCaseCarriers[1][1] + "\t" + pvalueCaseOnly + "\t" + expectedControlCarriers[0][0] + "/" + expectedControlCarriers[0][1] + "/" + expectedControlCarriers[1][0] + "/" + expectedControlCarriers[1][1] + expectedControlCarriers[0][0] + "/" + expectedControlCarriers[0][1] + "/" + expectedControlCarriers[1][0] + "/" + expectedControlCarriers[1][1] + "\t" + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + noOfControlCarriers[0][0] + "/" + noOfControlCarriers[0][1] + "/" + noOfControlCarriers[1][0] + "/" + noOfControlCarriers[1][1] + "\t" + pvalueCaseControl + "\t" + this.twiceDoubleF.format(disequilibria[0]) + "\t" + this.twiceDoubleF.format(disequilibria[1]) + "\t" + countOfNearbyHits + "\n");
            }
        }
        this.bwriter.flush();
    }

    public synchronized void Close() throws IOException {
        this.bwriter.flush();
        this.bwriter.close();
    }
}

