/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import preprocessing.WindowingSystem;
import statistics.SignificanceHelper;

public class NeededCaseCalculator
extends CaseMatrixBase {
    private final int Cases;
    private SignificanceHelper significance;

    public NeededCaseCalculator(UserParameters userparams, WindowingSystem windowmaker, SignificanceHelper significanceHelper) {
        super(windowmaker, userparams.getMaxorder());
        this.Cases = userparams.getNumber_of_cases();
        this.significance = significanceHelper;
        this.specialTypeOfOperation = MatrixOperations.calculateNeededCases;
        this.specialTypeOfOperand = MatrixOperations.calculateExpectedCases;
    }

    @Override
    public double doOperation(double operand) {
        double[][] expectedCases = new double[2][2];
        int[][] observedCases = new int[2][2];
        double pval = 1.0;
        int delta_case = 1;
        while (pval > this.significance.getCaseOnlyThreshold(this.currentDimension) && this.allIsWell(observedCases)) {
            switch (this.currentDimension) {
                case 1: {
                    expectedCases = this.windowMaker.getExpectedCases(new int[]{this.i}, this.Cases);
                    observedCases[1][1] = (int)Math.round(expectedCases[1][1] + (double)delta_case);
                    observedCases[1][0] = (int)Math.round(expectedCases[1][0] - (double)delta_case);
                    if (!this.allIsWell(observedCases)) break;
                    pval = this.significance.TestCasesOnly(this.currentDimension, observedCases);
                    break;
                }
                default: {
                    expectedCases = this.windowMaker.getExpectedCases(new int[]{this.i, this.j}, this.Cases);
                    observedCases[1][1] = (int)Math.round(expectedCases[1][1] + (double)delta_case);
                    observedCases[1][0] = (int)Math.round(expectedCases[1][0] - (double)delta_case);
                    observedCases[0][1] = (int)Math.round(expectedCases[0][1] - (double)delta_case);
                    observedCases[0][0] = (int)Math.round(expectedCases[0][0] + (double)delta_case);
                    if (!this.allIsWell(observedCases)) break;
                    pval = this.significance.TestCasesOnly(this.currentDimension, observedCases);
                }
            }
            ++delta_case;
        }
        if (!this.allIsWell(observedCases)) {
            observedCases[1][1] = this.Cases + 1;
            observedCases[1][0] = 0;
            observedCases[0][1] = 0;
            observedCases[0][0] = 0;
        }
        return observedCases[1][1];
    }

    private boolean allIsWell(int[][] observedCases) {
        return observedCases[1][1] >= 0 && observedCases[1][0] >= 0 && observedCases[0][1] >= 0 && observedCases[0][0] >= 0;
    }
}

