/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import preprocessing.WindowingSystem;

public class MaxCaseCalculator
extends CaseMatrixBase {
    private final double[] freqMaxes;

    public MaxCaseCalculator(UserParameters userparams, WindowingSystem windowmaker) {
        super(windowmaker, userparams.getMaxorder());
        this.freqMaxes = new double[windowmaker.getWindowBoundaries().length];
        int i = 0;
        while (i < windowmaker.getWindowBoundaries().length) {
            this.freqMaxes[i] = windowmaker.getWindowBoundaries()[i][1];
            ++i;
        }
        this.specialTypeOfOperation = MatrixOperations.calculateMaxCases;
        this.specialTypeOfOperand = MatrixOperations.calculateFrequency;
    }

    @Override
    public double doOperation(double expectedCarrierFreq) {
        switch (this.currentDimension) {
            case 1: {
                return this.freqMaxes[this.i];
            }
            case 2: {
                return Math.min(this.freqMaxes[this.i], this.freqMaxes[this.j]);
            }
            case 3: {
                return Math.min(Math.min(this.freqMaxes[this.i], this.freqMaxes[this.j]), this.freqMaxes[this.k]);
            }
        }
        return Math.min(Math.min(Math.min(this.freqMaxes[this.i], this.freqMaxes[this.j]), this.freqMaxes[this.k]), this.freqMaxes[this.m]);
    }
}

