/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import datastructures.UserParameters;
import gridmath.CaseMatrixBase;
import gridmath.MatrixOperations;
import preprocessing.WindowingSystem;

public class FrequencyCalculator
extends CaseMatrixBase {
    private final double[] freqMins;

    public FrequencyCalculator(UserParameters userparams, WindowingSystem windowmaker) {
        super(windowmaker, userparams.getMaxorder());
        double[][] windowBoundaries = windowmaker.getWindowBoundaries();
        this.freqMins = new double[windowBoundaries.length];
        int i = 0;
        while (i < windowBoundaries.length) {
            this.freqMins[i] = windowBoundaries[i][0];
            ++i;
        }
        this.specialTypeOfOperation = MatrixOperations.calculateFrequency;
        this.specialTypeOfOperand = null;
    }

    @Override
    public double doOperation(double operand) {
        switch (this.currentDimension) {
            case 1: {
                return this.freqMins[this.i];
            }
            case 2: {
                return this.freqMins[this.i] * this.freqMins[this.j];
            }
            case 3: {
                return this.freqMins[this.i] * this.freqMins[this.j] * this.freqMins[this.k];
            }
        }
        return this.freqMins[this.i] * this.freqMins[this.j] * this.freqMins[this.k] * this.freqMins[this.m];
    }
}

