/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import gridmath.AbstractCaseMatrix;
import gridmath.MatrixOperations;
import java.util.HashMap;
import preprocessing.WindowingSystem;

public class CaseMatrixBase
extends AbstractCaseMatrix {
    protected HashMap<MatrixOperations, Boolean> typesOfOperators = new HashMap();
    protected MatrixOperations specialTypeOfOperation;
    protected MatrixOperations specialTypeOfOperand;

    public CaseMatrixBase(WindowingSystem windowmaker, int maxD) {
        super(windowmaker, maxD);
        this.matrix1D = new double[this.noOfWindows];
        if (this.maxDimension > 1) {
            this.matrix2D = new double[this.noOfWindows][this.noOfWindows];
        }
        if (this.maxDimension > 2) {
            this.matrix3D = new double[this.noOfWindows][this.noOfWindows][this.noOfWindows];
        }
        if (this.maxDimension > 3) {
            this.matrix4D = new double[this.noOfWindows][this.noOfWindows][this.noOfWindows][this.noOfWindows];
        }
        this.resetIndices();
        this.typesOfOperators.put(MatrixOperations.greaterThan, true);
        this.typesOfOperators.put(MatrixOperations.lessThan, true);
        this.typesOfOperators.put(MatrixOperations.notEqZeroMask, true);
        this.typesOfOperators.put(MatrixOperations.copy, true);
        this.typesOfOperators.put(MatrixOperations.matrixMultiply, true);
        this.typesOfOperators.put(MatrixOperations.Exclusive, true);
        this.typesOfOperators.put(MatrixOperations.Union, true);
        this.specialTypeOfOperation = null;
        this.specialTypeOfOperand = null;
    }

    public void resetIndices() {
        this.i = 0;
        this.j = 0;
        this.k = 0;
        this.m = 0;
        this.currentDimension = 0;
    }

    public CaseMatrixBase(WindowingSystem windowmaker, int maxD, double initialValue) {
        this(windowmaker, maxD);
        this.i = 0;
        while (this.i < this.noOfWindows) {
            this.matrix1D[this.i] = initialValue;
            if (this.maxDimension > 1) {
                this.j = 0;
                while (this.j < this.noOfWindows) {
                    this.matrix2D[this.i][this.j] = initialValue;
                    if (this.maxDimension > 2) {
                        this.k = 0;
                        while (this.k < this.noOfWindows) {
                            this.matrix3D[this.i][this.j][this.k] = initialValue;
                            if (this.maxDimension > 3) {
                                this.m = 0;
                                while (this.m < this.noOfWindows) {
                                    this.matrix4D[this.i][this.j][this.k][this.m] = initialValue;
                                    ++this.m;
                                }
                            }
                            ++this.k;
                        }
                    }
                    ++this.j;
                }
            }
            ++this.i;
        }
    }

    public CaseMatrixBase compute(MatrixOperations operationType, CaseMatrixBase argumentMatrices, boolean inPlace) {
        if (!this.typesOfOperators.containsKey((Object)operationType) && argumentMatrices != null && this.specialTypeOfOperand != argumentMatrices.specialTypeOfOperation) {
            System.err.println("Incompatible operation " + (Object)((Object)operationType) + " requested from object.");
            System.exit(1);
        }
        CaseMatrixBase result = this;
        if (!inPlace) {
            result = new CaseMatrixBase(this.windowMaker, this.maxDimension).compute(MatrixOperations.copy, this, true);
            result.specialTypeOfOperation = this.specialTypeOfOperation;
            result.specialTypeOfOperand = this.specialTypeOfOperand;
        }
        if (argumentMatrices != null) {
            if (this.maxDimension > 1) {
                result.calculateMatrix2D(argumentMatrices.getMatrix2D(), operationType);
            }
        } else if (this.maxDimension > 1) {
            result.calculateMatrix2D(null, operationType);
        }
        this.resetIndices();
        return result;
    }

    public double doOperation(double operand) {
        System.err.println("Cannot perform complex/unspecified operation on this object");
        return operand;
    }

    @Override
    public double doOperation(double operand, MatrixOperations operation) {
        if (operation == MatrixOperations.greaterThan) {
            return this.greaterThan(operand);
        }
        if (operation == MatrixOperations.lessThan) {
            return this.lessThan(operand);
        }
        if (operation == MatrixOperations.notEqZeroMask) {
            return this.notEqZeroMask(operand);
        }
        if (operation == MatrixOperations.copy) {
            return this.copy(operand);
        }
        if (operation == MatrixOperations.matrixMultiply) {
            return this.matrixMultiply(operand);
        }
        if (operation == MatrixOperations.Exclusive) {
            return this.exclusive(operand);
        }
        if (operation == MatrixOperations.Union) {
            return this.union(operand);
        }
        return this.doOperation(operand);
    }

    public double greaterThan(double operand) {
        switch (this.currentDimension) {
            case 1: {
                if (this.matrix1D[this.i] >= operand) {
                    return this.matrix1D[this.i];
                }
                return 0.0;
            }
            case 2: {
                if (this.matrix2D[this.i][this.j] >= operand) {
                    return this.matrix2D[this.i][this.j];
                }
                return 0.0;
            }
            case 3: {
                if (this.matrix3D[this.i][this.j][this.k] >= operand) {
                    return this.matrix3D[this.i][this.j][this.k];
                }
                return 0.0;
            }
        }
        if (this.matrix4D[this.i][this.j][this.k][this.m] >= operand) {
            return this.matrix4D[this.i][this.j][this.k][this.m];
        }
        return 0.0;
    }

    public double lessThan(double operand) {
        switch (this.currentDimension) {
            case 1: {
                if (this.matrix1D[this.i] <= operand) {
                    return this.matrix1D[this.i];
                }
                return 0.0;
            }
            case 2: {
                if (this.matrix2D[this.i][this.j] <= operand) {
                    return this.matrix2D[this.i][this.j];
                }
                return 0.0;
            }
            case 3: {
                if (this.matrix3D[this.i][this.j][this.k] <= operand) {
                    return this.matrix3D[this.i][this.j][this.k];
                }
                return 0.0;
            }
        }
        if (this.matrix4D[this.i][this.j][this.k][this.m] <= operand) {
            return this.matrix4D[this.i][this.j][this.k][this.m];
        }
        return 0.0;
    }

    public double notEqZeroMask(double operand) {
        switch (this.currentDimension) {
            case 1: {
                return this.matrix1D[this.i] != 0.0 ? 1 : 0;
            }
            case 2: {
                return this.matrix2D[this.i][this.j] != 0.0 ? 1 : 0;
            }
            case 3: {
                return this.matrix3D[this.i][this.j][this.k] != 0.0 ? 1 : 0;
            }
        }
        return this.matrix4D[this.i][this.j][this.k][this.m] != 0.0 ? 1 : 0;
    }

    public double copy(double operand) {
        return operand;
    }

    public double matrixMultiply(double operand) {
        switch (this.currentDimension) {
            case 1: {
                return this.matrix1D[this.i] * operand;
            }
            case 2: {
                return this.matrix2D[this.i][this.j] * operand;
            }
            case 3: {
                return this.matrix3D[this.i][this.j][this.k] * operand;
            }
        }
        return this.matrix4D[this.i][this.j][this.k][this.m] * operand;
    }

    public double exclusive(double operand) {
        switch (this.currentDimension) {
            case 1: {
                return operand == 0.0 ? this.matrix1D[this.i] : 0.0;
            }
            case 2: {
                return operand == 0.0 ? this.matrix2D[this.i][this.j] : 0.0;
            }
            case 3: {
                return operand == 0.0 ? this.matrix3D[this.i][this.j][this.k] : 0.0;
            }
        }
        return operand == 0.0 ? this.matrix4D[this.i][this.j][this.k][this.m] : 0.0;
    }

    public double union(double operand) {
        switch (this.currentDimension) {
            case 1: {
                return this.matrix1D[this.i] == 0.0 ? operand : this.matrix1D[this.i];
            }
            case 2: {
                return this.matrix2D[this.i][this.j] == 0.0 ? operand : this.matrix2D[this.i][this.j];
            }
            case 3: {
                return this.matrix3D[this.i][this.j][this.k] == 0.0 ? operand : this.matrix3D[this.i][this.j][this.k];
            }
        }
        return this.matrix4D[this.i][this.j][this.k][this.m] == 0.0 ? operand : this.matrix4D[this.i][this.j][this.k][this.m];
    }
}

