/*
 * Decompiled with CFR 0.152.
 */
package gridmath;

import gridmath.MatrixOperations;
import java.util.Vector;
import preprocessing.WindowingSystem;

public abstract class AbstractCaseMatrix {
    protected WindowingSystem windowMaker;
    protected int noOfWindows;
    protected int maxDimension;
    protected double[] matrix1D;
    protected double[][] matrix2D;
    protected double[][][] matrix3D;
    protected double[][][][] matrix4D;
    protected int i;
    protected int j;
    protected int k;
    protected int m;
    protected int currentDimension;

    public AbstractCaseMatrix(WindowingSystem windowmaker, int maxD) {
        this.windowMaker = windowmaker;
        this.noOfWindows = this.windowMaker.getNoOfWindows();
        this.maxDimension = maxD;
    }

    public double doOperation(double operand, MatrixOperations operation) {
        System.err.println("Cannot perform operation on this object");
        return operand;
    }

    public double[] getMatrix1D() {
        return this.matrix1D;
    }

    public void calculateMatrix1D(double[] operand1D, MatrixOperations operationType) {
        this.currentDimension = 1;
        this.i = 0;
        while (this.i < this.noOfWindows) {
            this.matrix1D[this.i] = operand1D == null ? this.doOperation(0.0, operationType) : this.doOperation(operand1D[this.i], operationType);
            ++this.i;
        }
    }

    public double[][] getMatrix2D() {
        return this.matrix2D;
    }

    public void calculateMatrix2D(double[][] operand2D, MatrixOperations operationType) {
        this.currentDimension = 2;
        this.i = 0;
        while (this.i < this.noOfWindows) {
            this.j = this.i;
            while (this.j < this.noOfWindows) {
                this.matrix2D[this.i][this.j] = operand2D == null ? this.doOperation(0.0, operationType) : this.doOperation(operand2D[this.i][this.j], operationType);
                ++this.j;
            }
            ++this.i;
        }
    }

    public double[][][] getMatrix3D() {
        return this.matrix3D;
    }

    public void calculateMatrix3D(double[][][] operand3D, MatrixOperations operationType) {
        this.currentDimension = 3;
        this.i = 0;
        while (this.i < this.noOfWindows) {
            this.j = this.i;
            while (this.j < this.noOfWindows) {
                this.k = this.j;
                while (this.k < this.noOfWindows) {
                    this.matrix3D[this.i][this.j][this.k] = operand3D == null ? this.doOperation(0.0, operationType) : this.doOperation(operand3D[this.i][this.j][this.k], operationType);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    public double[][][][] getMatrix4D() {
        return this.matrix4D;
    }

    public void calculateMatrix4D(double[][][][] operand4D, MatrixOperations operationType) {
        this.currentDimension = 4;
        this.i = 0;
        while (this.i < this.noOfWindows) {
            this.j = this.i;
            while (this.j < this.noOfWindows) {
                this.k = this.j;
                while (this.k < this.noOfWindows) {
                    this.m = this.k;
                    while (this.m < this.noOfWindows) {
                        this.matrix4D[this.i][this.j][this.k][this.m] = operand4D == null ? this.doOperation(0.0, operationType) : this.doOperation(operand4D[this.i][this.j][this.k][this.m], operationType);
                        ++this.m;
                    }
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    public int getWindows() {
        return this.noOfWindows;
    }

    public Vector<int[]> getNonZeroCoordinates(int maxorder) {
        Vector<int[]> searchCoordinates = new Vector<int[]>();
        int i = 0;
        while (i < this.matrix1D.length) {
            if (this.matrix1D[i] != 0.0) {
                searchCoordinates.add(new int[]{i});
            }
            if (maxorder > 1) {
                int j = i;
                while (j < this.matrix2D[i].length) {
                    if (this.matrix2D[i][j] != 0.0) {
                        searchCoordinates.add(new int[]{i, j});
                    }
                    if (maxorder > 2) {
                        int k = j;
                        while (k < this.matrix3D[i][j].length) {
                            if (this.matrix3D[i][j][k] != 0.0) {
                                searchCoordinates.add(new int[]{i, j, k});
                            }
                            if (maxorder > 3) {
                                int m = k;
                                while (m < this.matrix4D[i][j][k].length) {
                                    if (this.matrix4D[i][j][k][m] != 0.0) {
                                        searchCoordinates.add(new int[]{i, j, k, m});
                                    }
                                    ++m;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return searchCoordinates;
    }
}

