/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

public class WorkUnit {
    private int[] requiredTrials;
    private double[] power_distribution;
    private int[] coordinates;
    private long exhaustiveCombinations;
    private double worstExpectedCombinations;

    public WorkUnit(int[] trials_per_k, double[] power_per_k, int[] coordinates, long exhaustiveCombinations, double worstCaseCombinations) {
        this.requiredTrials = trials_per_k;
        this.power_distribution = power_per_k;
        this.coordinates = coordinates;
        this.exhaustiveCombinations = exhaustiveCombinations;
        this.worstExpectedCombinations = worstCaseCombinations;
    }

    public long getBruteForceCombinationsInRegion() {
        return this.exhaustiveCombinations;
    }

    public double getWorstExpectedCombinationsFromRegion() {
        return this.worstExpectedCombinations;
    }

    public int[] getRequiredTrials() {
        return this.requiredTrials;
    }

    public double[] getPowerDistribution() {
        return this.power_distribution;
    }

    public void setRequiredTrials(int[] trial_spectrum) {
        this.requiredTrials = trial_spectrum;
    }

    public int getTotalRequiredTrials() {
        int total_trials = 0;
        int k = 0;
        while (k < this.requiredTrials.length) {
            total_trials += this.requiredTrials[k];
            ++k;
        }
        return total_trials;
    }

    public int[] getCoordinates() {
        return this.coordinates;
    }

    public String toStringBrief() {
        StringBuffer temp = new StringBuffer("[" + this.coordinates[0]);
        int box = 1;
        while (box < this.coordinates.length) {
            int window = this.coordinates[box];
            temp.append(" x " + window);
            ++box;
        }
        temp.append("]");
        return temp.toString();
    }

    public String toStringExtended() {
        return null;
    }
}

