/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class UserParameters {
    private String usage = "[USAGE :] See software webpage for complete usage documentation \n\t http://www.cs.columbia.edu/~snehitp/sixpac/ \n";
    private String fileprefix = "";
    private String mapfilename = "";
    private String frqfilename = "";
    private String pedfilename = "";
    private String phenofilename = "";
    private String geneticMapfilename = "";
    private String allRawfilename = "";
    private String caseRawfilename = "";
    private String controlRawfilename = "";
    private String significancefile = "sixpac";
    private String stage1output = "sixpac";
    private String stage2output = "sixpac.sxp";
    private String blockfile;
    private String avoidfile = "";
    private String testfile = "";
    private String mode = "pac";
    private int number_of_snps = 500000;
    private int number_of_cases = 20;
    private int number_of_controls = 20;
    private float f_hi = 0.5f;
    private float f_low = 0.0f;
    private boolean testRare = false;
    private long T_max = 10000000L;
    private float prevalence = 0.04f;
    private float power = 0.1f;
    private int verbose = 1;
    private double minPenetrance;
    private int maxorder = 2;
    private int maxThreads;
    private int maxHeapPerThread = 300;
    private float blockSizebp = 1000000.0f;
    private float blockSizecm = -1.0f;
    private double randomSeed;
    private int minHits = 1;
    private int lenience = 1;
    private double significance = 1.0;
    private double stage1CandidatesToOutput = 0.0;
    private double slope = 1.0;
    private double intercept = 0.0;
    private int span = 0;
    private long numberOfDraws = 0L;
    private int AllOrTransOrCis = 0;
    private boolean synergyOnly = false;
    private String testName = "R";
    private final int trialIncrement;
    private int numberOfTrialSlices = (int)Math.ceil(this.T_max / (long)this.trialIncrement);
    private int freqWindows = 79;
    private int oneTooManyCases;
    private int oneTooManyControls;
    private double p_lowest;
    private int marginals = 5;
    private double marginal_threshold = 5.0E-8;

    private UserParameters() {
        this.trialIncrement = 1000;
        this.minPenetrance = (double)this.prevalence + 1.0E-5;
        this.maxThreads = Runtime.getRuntime().availableProcessors();
        this.randomSeed = 1.0E8 * Math.random();
        this.oneTooManyCases = this.number_of_cases + 1;
        this.oneTooManyControls = this.number_of_controls + 1;
        this.p_lowest = 1.0 - Math.exp(Math.log(1.0f - this.power) / (double)this.T_max);
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMaxHeapPerThread() {
        return this.maxHeapPerThread;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMaxHeapPerThread(int maxHeapPerThread) {
        this.maxHeapPerThread = maxHeapPerThread;
    }

    public void setNumber_of_snps(int numberOfSnps) {
        this.number_of_snps = numberOfSnps;
    }

    public void setNumber_of_cases(int numberOfCases) {
        this.number_of_cases = numberOfCases;
        this.oneTooManyCases = numberOfCases + 1;
    }

    public void setNumber_of_controls(int numberOfControls) {
        this.number_of_controls = numberOfControls;
        this.oneTooManyControls = numberOfControls + 1;
    }

    public UserParameters(String[] args) {
        this();
        if (args.length < 2) {
            System.out.println(this.usage);
            System.exit(0);
        }
        System.out.println("\nRunning with inputs : ");
        int index = 0;
        while (index < args.length) {
            if (args[index].equals("--raw")) {
                this.allRawfilename = args[++index];
                System.out.println("\t --raw " + args[index]);
            } else if (args[index].equals("--cases")) {
                this.caseRawfilename = args[++index];
                System.out.println("\t --cases " + args[index]);
            } else if (args[index].equals("--controls")) {
                this.controlRawfilename = args[++index];
                System.out.println("\t --controls " + args[index]);
            } else if (args[index].equals("--out")) {
                this.stage1output = String.valueOf(args[++index]) + ".sxp.stage1";
                this.stage2output = String.valueOf(args[index]) + ".sxp";
                this.significancefile = String.valueOf(args[index]) + ".significance";
                System.out.println("\t --out " + args[index]);
            } else if (args[index].equals("--map")) {
                this.mapfilename = args[++index];
                System.out.println("\t --map " + args[index]);
            } else if (args[index].equals("--pheno")) {
                this.phenofilename = args[++index];
                System.out.println("\t --pheno " + args[index]);
            } else if (args[index].equals("--freq")) {
                this.frqfilename = args[++index];
                System.out.println("\t --freq " + args[index]);
            } else if (args[index].equals("--avoid")) {
                this.avoidfile = args[++index];
                System.out.println("\t --avoid " + args[index]);
            } else if (args[index].equals("--mode")) {
                this.mode = args[++index];
                System.out.println("\t --mode " + args[index]);
            } else if (args[index].equals("--verbose")) {
                this.verbose = Integer.parseInt(args[++index]);
                System.out.println("\t --verbose " + args[index]);
            } else if (args[index].equals("--useblockfile")) {
                this.blockfile = args[++index];
                System.out.println("\t --useblockfile " + args[index]);
            } else if (args[index].equals("--testfile")) {
                this.testfile = args[++index];
                System.out.println("\t --testfile " + args[index]);
            } else if (args[index].equals("--testname")) {
                this.testName = args[++index];
                System.out.println("\t --testname " + args[index]);
            } else if (args[index].equals("--genetic-map")) {
                this.geneticMapfilename = args[++index];
                System.out.println("\t --genetic-map " + args[index]);
            } else if (args[index].equals("--span")) {
                this.span = Integer.parseInt(args[++index]);
                System.out.println("\t --span " + args[index]);
            } else if (args[index].equals("--draws")) {
                this.numberOfDraws = Long.parseLong(args[++index]);
                System.out.println("\t --draws " + args[index]);
            } else if (args[index].equals("--in-trans")) {
                this.AllOrTransOrCis = 1;
                System.out.println("\t --in-trans");
            } else if (args[index].equals("--in-cis")) {
                this.AllOrTransOrCis = 2;
                System.out.println("\t --in-cis");
            } else if (args[index].equals("--synergy-only")) {
                this.synergyOnly = true;
                System.out.println("\t --synergy-only");
            } else if (args[index].equals("--fhi")) {
                this.f_hi = Float.parseFloat(args[++index]);
                System.out.println("\t --fhi " + args[index]);
            } else if (args[index].equals("--flow")) {
                this.f_low = Float.parseFloat(args[++index]);
                System.out.println("\t --flow " + args[index]);
            } else if (args[index].equals("--include-rare")) {
                this.testRare = true;
                System.out.println("\t --include-rare ");
            } else if (args[index].equals("--trials")) {
                this.T_max = Long.parseLong(args[++index]);
                this.numberOfTrialSlices = (int)Math.ceil(this.T_max / (long)this.trialIncrement);
                System.out.println("\t --trials " + args[index]);
            } else if (args[index].equals("--prevalence")) {
                this.prevalence = Float.parseFloat(args[++index]);
                System.out.println("\t --prevalence " + args[index]);
            } else if (args[index].equals("--power")) {
                this.power = Float.parseFloat(args[++index]);
                System.out.println("\t --power " + args[index]);
            } else if (args[index].equals("--seed")) {
                this.randomSeed = Float.parseFloat(args[++index]);
                System.out.println("\t --seed " + args[index]);
            } else if (args[index].equals("--penetrance")) {
                this.minPenetrance = Double.parseDouble(args[++index]);
                System.out.println("\t --penetrance " + args[index]);
            } else if (args[index].equals("--threads")) {
                this.maxThreads = Math.min(Integer.parseInt(args[++index]), Runtime.getRuntime().availableProcessors());
                this.maxHeapPerThread = 2000 / this.maxThreads;
                System.out.println("\t --threads " + args[index]);
            } else if (args[index].equals("--maxheap")) {
                this.maxHeapPerThread = Math.abs(Integer.parseInt(args[++index]));
                System.out.println("\t --maxheap " + args[index]);
            } else if (args[index].equals("--significance")) {
                this.significance = Math.abs(Double.parseDouble(args[++index]));
                System.out.println("\t --significance " + args[index]);
            } else if (args[index].equals("--stage1")) {
                this.stage1CandidatesToOutput = Double.parseDouble(args[++index]);
                System.out.println("\t --stage1 " + args[index]);
            } else if (args[index].equals("--order")) {
                this.maxorder = Integer.parseInt(args[++index]);
                System.out.println("\t --order " + args[index]);
            } else if (args[index].equals("--minhits")) {
                this.minHits = Integer.parseInt(args[++index]);
                if (this.minHits < 1) {
                    this.minHits = 1;
                }
                System.out.println("\t --minhits " + args[index]);
            } else if (args[index].equals("--windows")) {
                this.freqWindows = Integer.parseInt(args[++index]);
                System.out.println("\t --windows " + args[index]);
            } else if (args[index].equals("--useblocks-bp")) {
                this.blockSizebp = Float.parseFloat(args[++index]);
                System.out.println("\t --useblocks-bp " + args[index]);
            } else if (args[index].equals("--useblocks-cm")) {
                this.blockSizecm = Float.parseFloat(args[++index]);
                this.blockSizebp = -1.0f;
                System.out.println("\t --useblocks-cm " + args[index]);
            } else if (args[index].equals("--marginals")) {
                this.marginals = Integer.parseInt(args[++index]);
                System.out.println("\t --marginals " + args[index]);
            } else if (args[index].equals("--threshold")) {
                this.marginal_threshold = Float.parseFloat(args[++index]);
                System.out.println("\t --threshold " + args[index]);
            } else if (args[index].equals("--correction")) {
                StringTokenizer linearRegrParams;
                if ((linearRegrParams = new StringTokenizer(args[++index], ",")).countTokens() != 2) {
                    System.out.println("Format : [slope],[intercept]");
                    System.exit(1);
                }
                this.slope = Double.parseDouble(linearRegrParams.nextToken());
                this.intercept = Double.parseDouble(linearRegrParams.nextToken());
            } else {
                System.err.println("Invalid option \"" + args[index] + "\"");
                System.out.println(this.usage);
                System.exit(1);
            }
            ++index;
        }
        System.out.println();
        this.processInputs();
    }

    private void processInputs() {
        try {
            if (this.stage1CandidatesToOutput != 0.0) {
                FileWriter f1 = new FileWriter(this.stage1output);
                f1.close();
            }
            FileWriter f2 = new FileWriter(this.stage2output);
            f2.flush();
            String header = "SNP-1 \t SNP-2 \t Expected[Cases] \t Observed[Cases] \t p-val(Case-only) \t Expected[Controls] \t Observed[Controls] \t p-val(Case-Control) \t D'(cases) \t D'(controls) \n";
            if (this.verbose == 0) {
                header = "SNP-1 \t SNP-2 \t D'(cases) \t p-val(Case-only) \t D'(controls) \t p-val(Case-Control) \n";
            }
            if (this.verbose == 2) {
                header = "SNP-1 \t SNP-2 \t Expected[Cases] \t Observed[Cases] \t p-val(Case-only) \t Expected[Controls] \t Observed[Controls] \t p-val(Case-Control) \t D'(cases) \t D'(controls) \tCase-Carriers \t Control-Carriers \n";
            }
            if (this.span == 0) {
                f2.write(header);
            }
            f2.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.p_lowest = 1.0 - Math.exp(Math.log(1.0f - this.power) / (double)this.T_max);
    }

    public String getFilePrefix() {
        return this.fileprefix;
    }

    public String getMapfilename() {
        return this.mapfilename;
    }

    public String getPhenofilename() {
        return this.phenofilename;
    }

    public String getFrqfilename() {
        return this.frqfilename;
    }

    public String getPedfilename() {
        return this.pedfilename;
    }

    public String getAvoidfilename() {
        return this.avoidfile;
    }

    public String getTestfilename() {
        return this.testfile;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getGeneticMapFile() {
        return this.geneticMapfilename;
    }

    public int getSpan() {
        return this.span;
    }

    public boolean getSynergyOnly() {
        return this.synergyOnly;
    }

    public long getNumberOfDraws() {
        return this.numberOfDraws;
    }

    public int getAllOrTransOrCis() {
        return this.AllOrTransOrCis;
    }

    public String getCasefilename() {
        return this.caseRawfilename;
    }

    public String getControlfilename() {
        return this.controlRawfilename;
    }

    public String getSensitivityfilename() {
        return this.significancefile;
    }

    public String getStage1Output() {
        return this.stage1output;
    }

    public String getStage2Output() {
        return this.stage2output;
    }

    public String getBlockfilename() {
        return this.blockfile;
    }

    public String getMode() {
        return this.mode;
    }

    public int getNumber_of_snps() {
        return this.number_of_snps;
    }

    public int getNumber_of_cases() {
        return this.number_of_cases;
    }

    public int getNumber_of_controls() {
        return this.number_of_controls;
    }

    public float getF_low() {
        return this.f_low;
    }

    public float getF_hi() {
        return this.f_hi;
    }

    public int getNumberOfTrialSlices() {
        return this.numberOfTrialSlices;
    }

    public int getTrialIncrement() {
        return this.trialIncrement;
    }

    public boolean toTestRare() {
        return this.testRare;
    }

    public long getT_max() {
        return this.T_max;
    }

    public float getPrevalence() {
        return this.prevalence;
    }

    public double getPenetrance() {
        return this.minPenetrance;
    }

    public float getPower() {
        return this.power;
    }

    public int getMaxorder() {
        return this.maxorder;
    }

    public int getLenience() {
        return this.lenience;
    }

    public double getSignificanceThreshold() {
        return this.significance;
    }

    public int getMinHits() {
        return this.minHits;
    }

    public double getRandomSeed() {
        return this.randomSeed;
    }

    public int getFreqWindows() {
        return this.freqWindows;
    }

    public float getBlockSizeBp() {
        return this.blockSizebp;
    }

    public float getBlockSizeCm() {
        return this.blockSizecm;
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public void setIntercept(double intercept) {
        this.intercept = intercept;
    }

    public int getOneTooManyCases() {
        return this.oneTooManyCases;
    }

    public int getOneTooManyControls() {
        return this.oneTooManyControls;
    }

    public double getP_lowest() {
        return this.p_lowest;
    }

    public int getMarginals() {
        return this.marginals;
    }

    public double getMarginal_threshold() {
        return this.marginal_threshold;
    }

    public String getAllRawfilename() {
        return this.allRawfilename;
    }

    public int getVerboseState() {
        return this.verbose;
    }

    public double howManyStage1CandidatesToOutput() {
        return this.stage1CandidatesToOutput;
    }

    public void setstage1CandidatesToOutput(int howManyStage1CandidatesToOutput) {
        this.stage1CandidatesToOutput = howManyStage1CandidatesToOutput;
    }
}

